/*----------------------------------------------------------------------------
--
--  Module:           xitBusyDia
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Display a busy dialog with a 'Cancel' button. When the user
--    presses Cancel, the dialog is removed.
--
--  Filename:         xitBusyDia.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-01-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitBusyDia.c, Version: 1.1, Date: 95/02/18 15:10:19";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include "System.h"

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  cancelCB( Widget     widget,
            XtPointer  client_data,
            XtPointer  call_data );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateBusyDialog( Widget parent, 
                       char   *dialog_name,
                       char   *title,
                       char   *message )
{

  /* Variables. */
  Arg        args[ 5 ];
  Cardinal   n;
  Widget     workW;


  /* Code. */

  /* Create a working dialog. */
  workW = xitCreateWorkingDialog( parent,   dialog_name, 
                                  title,    message,
                                  NULL,     NULL,
                                  cancelCB, NULL );

  n = 0;
  XtSetArg( args[ n ], XmNautoUnmanage, False );  n++;
  XtSetValues( workW, args, n );

  /* Use user data to indicate that the dialog is done. */
  n = 0;
  XtSetArg( args[ n ], XmNuserData, 0 ); n++;
  XtSetValues( workW, args, n );
  

  return( workW );

} /* xitCreateBusyDialog */


/*----------------------------------------------------------------------*/

Boolean
  xitBusyDialogCancelled( Widget        workW,
                          XtAppContext  context )
{

  /* Variables. */
  int       cancel_flag;
  Arg       args[ 5 ];
  Cardinal  n;


  /* Code. */

  if( workW == NULL )
    return( True );

  /* Process pending X events. */
  while( XtAppPending( context ) ) {

    XEvent  event;

    XtAppNextEvent(  context, &event );
    XtDispatchEvent( &event );

  } /* while */


  /* Was the cancel callback called? */
  n = 0;
  XtSetArg( args[ n ], XmNuserData, &cancel_flag ); n++;
  XtGetValues( workW, args, n );

  if( cancel_flag == 1 )
    return( True );


  return( False );

} /* xitBusyDialogCancelled */


/*----------------------------------------------------------------------*/

void
  xitBusyDialogRemove( Widget  workW )
{

  /* Code. */

  if( workW != NULL )
    XtDestroyWidget( workW );


  return;

} /* xitBusyDialogRemove */


/*----------------------------------------------------------------------*/

static void
  cancelCB( Widget     widget,
            XtPointer  client_data,
            XtPointer  call_data )
{

  /* Variables. */
  Arg       args[ 5 ];
  Cardinal  n;


  /* Code. */

  n = 0;
  XtSetArg( args[ n ], XmNuserData, 1 ); n++;
  XtSetValues( widget, args, n );


  return;

} /* cancelCB */
