/*----------------------------------------------------------------------------
--
--  Module:           xitCreLaWi
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a label widget.
--
--  Filename:         xitCreLaWi.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreLaWi.c, Version: 1.1, Date: 95/02/18 15:10:25";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Label.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateLabelWidget( Widget parent,
                        char   *name,
                        char   *string,
                        int    alignment )
{

  /* Variables. */
  Arg         args[ 5 ];
  Cardinal    n;
  Widget      label;
  XmString    xstr = NULL;


  /* Code. */

  n = 0;

  if( strlen( string ) > 0 ) {
    xstr = XmStringCreateLtoR( string, CS );
    XtSetArg( args[ n ], XmNlabelString, xstr ); n++;
  }

  if( alignment >= 0 ) {
    XtSetArg( args[ n ], XmNalignment, alignment ); n++;
  } else {
    XtSetArg( args[ n ], XmNalignment, XmALIGNMENT_BEGINNING ); n++;
  }

  label = XmCreateLabel( parent, name, args, n );

  if( strlen( string ) > 0 )
    XmStringFree( xstr );

  return( label );

} /* xitCreateLabelWidget */
