/*----------------------------------------------------------------------------
--
--  Module:           xitMsgWin
--
--  Module:           xitMsgWin
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xitMsgWin.
--
--  Filename:         xitMsgWin.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-06-16
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitMsgWin.h, Version: 1.1, Date: 95/02/18 15:10:42 */


/* Include this module only once. */
#ifndef define_xitMsgWin_h
#  define define_xitMsgWin_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the message window. */
typedef  void  *XIT_MSW_HANDLE;

/* Labels to use in the window. */
typedef struct {
  char  *title;
  char  *list_label;
  char  *clear_button;
  char  *close_button;
} XIT_MSW_LABEL_REC;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitMsgWinClearWindow( XIT_MSW_HANDLE  msg_win_handle );

XIT_MSW_HANDLE
  xitCreateMsgWindow( Widget             parent,
                      int                max_messages,
                      char               *log_file,
                      XIT_MSW_LABEL_REC  *labels );

void
  xitMsgWinDestroy( XIT_MSW_HANDLE  msg_win_handle );

void
  xitMsgWinDisplayMessage( XIT_MSW_HANDLE  msg_win_handle,
                           char            *msg,
                           int             msg_id );

#endif
