#!../../bin/wish -f

proc SetUserPreferences { fedotPath } {
	global settings env
		 
 	set settings(height)      700
	set settings(width)       450
	set settings(show_hidden) 0
	set settings(editor)      nedit
	set settings(viewer)      "hpterm -title View -e $fedotPath/Fedot.rscr more"
	set settings(terminal)    hpterm
	set settings(left_list)   brief
	set settings(right_list)  brief
	set settings(list_font)        "-adobe-courier-medium-r-normal--18-180-75-75-m-110-koi8-1"
	set settings(run_command_font) "-misc-fixed-medium-r-normal--16-120-100-100-c-90-iso8859-1" 
	
	# Initial directories
	set settings(dirLeft)  "$env(HOME)"
	set settings(dirRight) "$env(HOME)"
	
	# Set some colors
	set settings(color_bg)         "#4E6AD5"
	set settings(color_button)     "#4E6AD5"
	set settings(color_warning_bg) Red
	
	if { [string compare $fedotPath "" ] == 0 } {
	        set settings(prog_path) "."
		set conf $settings(name).conf
	} else {
	        set settings(prog_path) $fedotPath
		set conf $fedotPath/$settings(name).conf
	}
	
	if [ catch { open $conf r } pref ] {
		Message "Load Preferences" "Can't open preferences file! Use default values." 1
		return
        }
	
	while { [ gets $pref line ] >= 0 } {
	   if [regexp {#\*([.]*)} $line nul ] {
	   	#comments
	       continue
	   } elseif [regexp {Height:([^:]*)} $line nul stt ] {
		set settings(height) $stt
	   } elseif [regexp {Width:([^:]*)} $line nul stt ] {
		set settings(width) $stt
	   } elseif [regexp {Show_hidden:([^:]*)} $line nul stt ] {
		set settings(show_hidden) $stt
	   } elseif [regexp {Editor:([^:]*)} $line nul stt ] {
		set settings(editor) $stt
	   } elseif [regexp {Viewer:([^:]*)} $line nul stt ] {
		set settings(viewer) $stt
	   } elseif [regexp {Terminal:([^:]*)} $line nul stt ] {
		set settings(terminal) $stt
	   } elseif [regexp {File_list_left:([^:]*)} $line nul stt ] {
		set settings(left_list) $stt
	   } elseif [regexp {File_list_right:([^:]*)} $line nul stt ] {
		set settings(right_list) $stt
	   } elseif [regexp {Dir_left:([^:]*)} $line nul stt ] {
	   	if [ file exists $stt ] {
			set settings(dirLeft) $stt
		} else {
			Message "Fedot: Load Preferences"\
			        "Initial directory for left panel don't exists" 1
		}
	   } elseif [regexp {Dir_right:([^:]*)} $line nul stt ] {
	   	if [ file exists $stt ] {
			set settings(dirRight) $stt
		} else {
			Message "Fedot: Load Preferences"\
			        "Initial directory for right panel don't exists" 1
		}
	   } elseif [regexp {Prog_path:([^:]*)} $line nul stt ] {
		set settings(prog_path) $stt
	   } elseif [regexp {Color_bg:([^:]*)} $line nul stt ] {
		set settings(color_bg) $stt
	   } elseif [regexp {Color_button:([^:]*)} $line nul stt ] {
		set settings(color_button) $stt
	   } elseif [regexp {Color_warning_bg:([^:]*)} $line nul stt ] {
		set settings(color_warning_bg) $stt
	   } elseif [regexp {Run_Command_Font:([^:]*)} $line nul stt ] {
		set settings(run_command_font) $stt
	   } elseif [regexp {List_Font:([^:]*)} $line nul stt ] {
		set settings(list_font) $stt
	   }
	}
}

proc SetExtAssociations {} {
	global settings extensions env
		 
	set ext $settings(prog_path)/$settings(name).ext
	
	if [ catch { open $ext r } file ] { return }
	
	while { [ gets $file line ] >= 0 } {
	   if [ regexp {#\*([.]*)} $line nul ] {
	   	#comments
	       continue
	   } elseif { [regexp {([^:]*):([^:]*)} $line all ext com ] == 1 } {
		set extensions($ext) $com
	   }
	}
}

# Destroy toplevel widget to finish a dialog
proc QuitTopLevel { window } {
	destroy $window
}

proc ToLeft {} {
	global settings
	
        set settings(currentPane) left
        cd $settings(dirLeft)
	focus .lists.l.left
}

proc ToRight {} {
	global settings
	
	set settings(currentPane) right
        cd $settings(dirRight)
	focus .lists.r.right
}

proc ReadDir { dir pane } {
	global settings dirList
	
	if { $settings(show_hidden) == 1 } { set option "-a" }
	
	if { [string compare $pane "left" ] == 0 } {
	    set full [string compare $settings(left_list) "brief" ]
	} else {
	    set full [string compare $settings(right_list) "brief" ]
	}
        
	if { $full == 0 } {
		if { $settings(show_hidden) == 0 } {
			set dirList  [exec ls $dir ]
		} else {
			set dirList  [exec ls $option $dir ]
		}
	} else {
		if { $settings(show_hidden) == 0 } {
			set dirList [exec ls $dir ]
		} else {
			set dirList [exec ls $option $dir ]
		}
		
		set len [ llength $dirList ]
		
		for { set i 0 } { $i < $len } { incr i } {
		  set item [ lindex $dirList $i ] 
		  if { [ file isfile $dir/$item ] || \
		       [ file isdirectory $dir/$item ] } {
		  	set size [ file size $dir/$item ]
		  } else {
		  	set size 0
		  }

		  if [ file isdirectory $dir/$item ] { set isd "<dir>"} else { set isd "     " }
		  #if [ file executable  $dir/$item ] { set isx "e"} else { set isx " " }
		  #if [ file readable	 $dir/$item ] { set isr "r"} else { set isr "-" }
		  #if [ file writable	 $dir/$item ] { set isw "w"} else { set isw "-" }
		
		  #set prop $isd$isr$isw$isx
		  set prop $isd
		
		  set dirList [ lreplace $dirList\
		      $i $i [format "%-20s %-8d %-5s" $item $size $prop ] ]
 		}        
	}
}

proc ReRead { which } {
	global dirList settings
	
	if { [string compare $which "left"] == 0 } {
		set list .lists.l.left
	        # Sets dirList
		ReadDir $settings(dirLeft) "left"
		.lists.l.dir config -text $settings(dirLeft)
	} else {
		set list .lists.r.right
	        # Sets dirList
		ReadDir $settings(dirRight) "right"
		.lists.r.dir config -text $settings(dirRight)
	}
	
	$list delete 0 end 
	
	if { $settings(show_hidden) == 0 } {
		$list  insert end "..<up> " 
	}
	
	set len [ llength $dirList ]
	for { set i 0 } { $i < $len } {incr i } {
		set dirItem [ lindex $dirList $i ]
		$list  insert end $dirItem 
 	}        
}

proc YesNo { title question mode } {
	global settings
	
        if { $mode == 3 || $mode == 4 } { # Warnings variants: red color
        	set color $settings(color_warning_bg)
        } else {                          # Normal wariant: use user color
        	set color $settings(color_button)
        }
	
	toplevel .yesnoWindow -bg $color
	wm title .yesnoWindow $title
        
        
        set text "   $question   "
        label .yesnoWindow.question -text $text -bg $color
	pack .yesnoWindow.question -side top -padx 5 -pady 10
	
	frame .yesnoWindow.separator -borderwidth 0 -bg Black -height 1
	pack  .yesnoWindow.separator -side top -fill x -pady 5
	
	frame .yesnoWindow.b  -bg $color
	
        button .yesnoWindow.b.yes -bg $color -text Yes\
        	-command { YesNoAnswer 1 }
        pack .yesnoWindow.b.yes -side left -padx 10 -pady 10
        
        if { $mode == 1 } { # extended mode Yes/No/Yes To All
        	button .yesnoWindow.b.yestoall -bg $color -text "Yes To All"\
        	-command { YesNoAnswer 2 }
        	pack .yesnoWindow.b.yestoall -side left -padx 10 -pady 10
        	bind .yesnoWindow <Control-a> { YesNoAnswer 2 }
        }
        
        button .yesnoWindow.b.no  -bg $color -text No\
        -command { YesNoAnswer 0 }
        pack .yesnoWindow.b.no -side left -padx 10 -pady 10
        
        pack .yesnoWindow.b -side bottom

        bind .yesnoWindow <Escape>    { YesNoAnswer 0 }
        bind .yesnoWindow <Control-c> { YesNoAnswer 0 }
        
}

proc YesNoAnswer { answ } {
     global answerYesNo 
     set answerYesNo $answ
     QuitTopLevel .yesnoWindow
}

proc Message { title whatToSay mode } {
	global settings
	
	if { $mode == 0 } {       # normal  mode
		set color $settings(color_button)
	} elseif { $mode == 1 } {  # warning mode
		set color $settings(color_warning_bg)
	}
	
	toplevel .messageWindow -bg $color
	
	wm title .messageWindow $title
        
        set width [ string length $whatToSay ]
        set message "    $whatToSay    "
        
	label .messageWindow.info -text $message -relief flat -bg $color
	pack  .messageWindow.info -side top -padx 10 -pady 10 -fill both -expand true
	
	frame .messageWindow.separator -borderwidth 0 -bg Black -height 1
	pack  .messageWindow.separator -side top -fill x
	
        button .messageWindow.quit -text Quit -command { QuitTopLevel .messageWindow }\
                                   -bg $color  
        pack .messageWindow.quit -side bottom -padx 5 -pady 10

        bind .messageWindow <Return>    { QuitTopLevel .messageWindow }
        bind .messageWindow <Escape>    { QuitTopLevel .messageWindow }
        bind .messageWindow <Control-c> { QuitTopLevel .messageWindow }
}

proc MessageLong { title whatToSay width height } {
	global settings
	
	toplevel .messageWindow -bg $settings(color_bg)
	
	wm title .messageWindow $title
        wm minsize .messageWindow $width $height 
        
	frame .messageWindow.t -bg $settings(color_button)
	text .messageWindow.t.log -width $width -height $height -borderwidth 2\
	         -relief sunken -setgrid true -bg $settings(color_bg) -fg White\
         	 -yscrollcommand {.messageWindow.t.scroll set }\
         	 -font $settings(run_command_font)
	scrollbar .messageWindow.t.scroll -width 10 -bg $settings(color_bg)\
	          -command {.messageWindow.t.log yview }
	          
	pack .messageWindow.t.scroll -side right -fill y
	pack .messageWindow.t.log -side left -fill both -expand true
	pack .messageWindow.t -side top -fill both -expand true
	
	frame .messageWindow.separator -borderwidth 0 -bg Black -height 1
	pack  .messageWindow.separator -side top -fill x
	
        button .messageWindow.quit -text Quit -command { QuitTopLevel .messageWindow }\
                                   -bg $settings(color_bg) 
        pack .messageWindow.quit -side bottom -padx 5 -pady 10

        bind .messageWindow <Return>    { QuitTopLevel .messageWindow }
        bind .messageWindow <Escape>    { QuitTopLevel .messageWindow }
        bind .messageWindow <Control-c> { QuitTopLevel .messageWindow }

	.messageWindow.t.log insert end $whatToSay\n
	.messageWindow.t.log see 1.1
}

proc Dialog { title question defaultValue whatExecute mode } {
	global commandToExecute settings

	toplevel .questWindow -bg $settings(color_button)
	
	wm title .questWindow $title
        wm minsize .questWindow 500 140 
        
        set commandToExecute $whatExecute
	
 	frame .questWindow.t  -bg $settings(color_button) 
	label .questWindow.t.quest -text $question \
		-bg $settings(color_button)
	entry .questWindow.t.edit -relief sunken -textvariable whatEntered
	.questWindow.t.edit delete 0 end
	.questWindow.t.edit insert 0 $defaultValue
	
	pack .questWindow.t.quest -side top -padx 10 -pady 10
	pack .questWindow.t.edit -side left -fill x -expand true
	pack .questWindow.t -side top -fill both -expand true
	
	bind .questWindow.t.edit <Return>    { OkDialog     $whatEntered 0 }
	bind .questWindow.t.edit <Control-c> { QuitTopLevel .questWindow }
	bind .questWindow.t.edit <Escape>    { QuitTopLevel .questWindow }
	
	frame .questWindow.separator -borderwidth 0 -bg Black -height 1
	pack  .questWindow.separator -side top -fill x
	
	frame .questWindow.b  -bg $settings(color_button) 
        button .questWindow.b.yes     -bg $settings(color_button) -text Yes\
            -command { OkDialog $whatEntered 0 } 
        pack .questWindow.b.yes -side left -padx 10 -pady 10
        
        if { $mode == 1 } { # extended mode Yes/Yes To All/No
        	button .questWindow.b.yestoall -bg $settings(color_button)\
        		-text "Yes To All" -command { OkDialog $whatEntered 2 }
       		pack .questWindow.b.yestoall  -side left -padx 10 -pady 10
       	}
        	
        button .questWindow.b.no -bg $settings(color_button)\
        	-text No -command { QuitTopLevel .questWindow }
        pack  .questWindow.b.no -side left -padx 10 -pady 10
        
        pack .questWindow.b -side bottom
        
        focus .questWindow.t.edit
}

proc OkDialog { entered mode } {
	global answer modeDialog commandToExecute
	if { $mode == 2 } { # yes to all
	        set modeDialog 2
	} 
	
	set answer $entered

	destroy .questWindow
	eval { $commandToExecute }
}

# -----------------------------------------------------------------
#
#                             MAIN PROCEDURE
#
# -----------------------------------------------------------------

# Is variable FEDOT_PATH setted
set path [array names env]
if { [ lsearch -exact $path "FEDOT_PATH" ] >= 0 } {
	puts "Fedot: variable FEDOT_PATH detected as $env(FEDOT_PATH)"
	set fedotPath $env(FEDOT_PATH)
} else {
	puts "Fedot: variable FEDOT_PATH is not detected."
	set fedotPath ""
}
  
# Variables
set dirList [ list "" ]

set answer ""
set commandToExecute ""
set commandIndex 1
# Some settings
set settings(version)  "1.00"
set settings(name)     "Fedot"

# command "exec" is stupid...
#set settings(viewer1)   "hpterm"
#set settings(viewer2)   "-e"
#set settings(viewer3)   "more"

set settings(currentPane) left

# Firstly - load user preferences ( store them in "settings" array )
SetUserPreferences $fedotPath

# Secondly - load extension associations ( store them in "extensions" array )
SetExtAssociations

# Set main window parameters 
. config -bg $settings(color_bg)
wm title   . "$settings(name) v$settings(version)"
wm minsize . $settings(height) $settings(width)

# Global key bindings
bind all <Key-F1>  Help
bind all <Key-F2>  Menu
bind all <Key-F3>  View
bind all <Key-F4>  Edit
bind all <Key-F5>  Copy
bind all <Key-F6>  Move
bind all <Key-F7>  { Dialog "Make Directory" "Enter name of new directory" "" "MkDir" 0}
bind all <Key-F8>  Delete
bind all <Key-F9>  RunTerm
bind all <Key-F10> Quit

# Create a frame for buttons and entry 
frame .top -borderwidth 0 -bg $settings(color_button) 
pack  .top -side top -fill x

frame .separator -borderwidth 0 -bg Black -height 1
pack  .separator -side top -fill x

# LEFT
menubutton .top.bLeft -text Left -menu .top.bLeft.menuLeft\
	-bg $settings(color_button) -fg White
pack .top.bLeft -side left -ipadx 10 -pady 0 
set menuLeft [menu .top.bLeft.menuLeft -tearoff 0 -fg White ]
$menuLeft add command -label "Listing Mode"     -command { ChooseListMode left }
$menuLeft add command -label "Rescan ( Ctrl-R)"	-command { ReRead left }
$menuLeft add command -label "Up     ( Ctrl-U)"	-command { LevelUp left }
.top.bLeft.menuLeft config -bg $settings(color_button) -fg White

# OPTIONS
menubutton .top.bOptions -text Options -menu .top.bOptions.menuOptions\
                         -bg $settings(color_button) -fg White
pack .top.bOptions -side left -ipadx 10 -pady 0 
set menuOptions [menu .top.bOptions.menuOptions -tearoff 0 -fg White ]
$menuOptions add command -label "User Preferences"  -command EditUserPreferences
$menuOptions add command -label "User Menu"         -command EditUserMenu
$menuOptions add command -label "Ext. Associations" -command EditExtAssociations
.top.bOptions.menuOptions config -bg $settings(color_button)

# RIGHT                      
menubutton .top.bRight -text Right -menu .top.bRight.menuRight\
                      -bg $settings(color_button) -fg White
pack .top.bRight -side left -ipadx 10 -pady 0 
set menuRight [menu .top.bRight.menuRight -tearoff 0 -fg White ]
$menuRight add command -label "Listing Mode"     -command { ChooseListMode right  }
$menuRight add command -label "Rescan ( Ctrl-R)" -command { ReRead right }
$menuRight add command -label "Up     ( Ctrl-U)" -command { LevelUp right }
.top.bRight.menuRight config -bg $settings(color_button)

# HELP
menubutton .top.bHelp -text Help -menu .top.bHelp.menuHelp\
		      -bg $settings(color_button) -fg White
pack .top.bHelp -side right -ipadx 10 -pady 0 
set menuHelp [menu .top.bHelp.menuHelp -tearoff 0 -fg White ]
$menuHelp add command -label Help  -command Help
$menuHelp add command -label About -command About
.top.bHelp.menuHelp config -bg $settings(color_button)

frame .lists -bg $settings(color_bg)
pack  .lists -side top -fill both -expand true

frame .lists.l -bg $settings(color_bg)
pack  .lists.l -side left -fill both -expand true -padx 5

label .lists.l.dir -text $settings(dirLeft) -bg $settings(color_bg)
pack  .lists.l.dir -side top -fill x -padx 10 -pady 2

listbox .lists.l.left  -bg $settings(color_bg) -fg White -selectmode multiple\
	-yscrollcommand [list .lists.l.lsy set]\
	-font $settings(list_font)

frame .lists.r -bg $settings(color_bg)
pack  .lists.r -side right -fill both -expand true -padx 5

label .lists.r.dir -text $settings(dirRight) -bg $settings(color_bg)
pack  .lists.r.dir -side top -fill x -padx 10 -pady 2

listbox .lists.r.right -bg $settings(color_bg) -fg White -selectmode multiple\
	-yscrollcommand [list .lists.r.rsy set]\
	-font $settings(list_font)

ReRead left
ReRead right

# Create scrollbars attached to the listbox
scrollbar .lists.l.lsy -orient vertical -width 12 -highlightthickness 0\
	  -bg $settings(color_bg) -troughcolor $settings(color_bg)\
	  -activebackground $settings(color_bg)\
	  -command [list .lists.l.left  yview] -borderwidth 3
		    
scrollbar .lists.r.rsy -orient vertical -width 12 -highlightthickness 0\
	  -bg $settings(color_bg) -troughcolor $settings(color_bg)\
	  -activebackground $settings(color_bg)\
          -command [list .lists.r.right yview] -borderwidth 3

# Arrange them in the parent frame
pack .lists.l.left  -side left -pady 5 -fill both -expand true
pack .lists.l.lsy   -side left -fill y -pady 5
pack .lists.r.right -side left -pady 5 -fill both -expand true
pack .lists.r.rsy   -side left -fill y -pady 5

focus .lists.l.left

bind .lists.r.right <Return>         RunItem 
bind .lists.l.left  <Return>         RunItem
bind .lists.r.right <Control-Return> { AddFileToComm right } 
bind .lists.l.left  <Control-Return> { AddFileToComm left  }
bind .lists.r.right <Control-r> { ReRead right } 
bind .lists.l.left  <Control-r> { ReRead left  }
bind .lists.r.right <Control-u> { LevelUp right } 
bind .lists.l.left  <Control-u> { LevelUp left  }
bind .lists.r.right <Left>      ToLeft
bind .lists.l.left  <Right>     ToRight
bind .lists.r.right <Button-1>  ToRight
bind .lists.l.left  <Button-1>  ToLeft
bind .lists.l.left  <Tab>       ToRight
bind .lists.r.right <Double-Button-1> RunItem
bind .lists.l.left  <Double-Button-1> RunItem
bind .lists.r.right <Insert> MarkItem
bind .lists.l.left  <Insert> MarkItem
bind .lists.r.right <Key-equal>       { SelectFiles }
bind .lists.r.right <Key-KP_Add>      { SelectFiles }
bind .lists.r.right <Key-minus>       { UnSelectFiles }
bind .lists.r.right <Key-KP_Subtract> { UnSelectFiles }
bind .lists.l.left  <Key-equal>       { SelectFiles }
bind .lists.l.left  <Key-KP_Add>      { SelectFiles }
bind .lists.l.left  <Key-minus>       { UnSelectFiles }
bind .lists.l.left  <Key-KP_Subtract> { UnSelectFiles }

# Create the command buttons
#Help Menu View Edit Copy Move MkDir Delete PullD Quit

frame .bottom -borderwidth 0 -bg $settings(color_button)

button .bottom.help -text Help -command Help -bg $settings(color_button)
button .bottom.menu -text Menu -command Menu -bg $settings(color_button)
button .bottom.view -text View -command View -bg $settings(color_button)
button .bottom.edit -text Edit -command Edit -bg $settings(color_button)
button .bottom.copy -text Copy -command Copy -bg $settings(color_button)
button .bottom.move -text Move -command Move -bg $settings(color_button)
button .bottom.mkdir -text MkDir -bg $settings(color_button)\
       -command { Dialog "Make Directory" "Enter name of new directory" "" "MkDir" 0 }
button .bottom.delete -text Delete -command Delete -bg $settings(color_button)
button .bottom.term   -text Term -command RunTerm  -bg $settings(color_button)
button .bottom.quit   -text Quit -command Quit     -bg $settings(color_button)

pack .bottom.help .bottom.menu .bottom.view .bottom.edit .bottom.copy\
     .bottom.move .bottom.mkdir .bottom.delete .bottom.term .bottom.quit\
     -side left -expand true -ipadx 0 -padx 0 -pady 5 -ipady 0
pack .bottom -side bottom -fill x

# create separator
frame .separator2 -borderwidth 0 -bg White  -height 1
pack  .separator2 -side bottom -fill x
frame .separator3 -borderwidth 0 -bg $settings(color_bg)  -height 5
pack  .separator3 -side bottom -fill x

# Create  entry for the command
entry .cmd -relief sunken -bg $settings(color_bg)\
		-textvariable command
pack  .cmd -side top -padx 3 -pady 3 -fill x 

# Set up key binding equivalences to the buttons
bind .cmd <Return>         Run
bind .cmd <Control-Return> Run
bind .cmd <Control-c>      Quit



# ---------------------------------------------------
#
#                 End of main procedure 
#
# ---------------------------------------------------

# Run the program and arrange to read its input 
proc Run { } {
	global input command log settings env commandIndex

  	if {[ string compare $settings(currentPane) left ] == 0 } {
  	  	 cd $settings(dirLeft)
  	} else {
  	  	 cd $settings(dirRight)
  	}

	#if [ string match *|* $command ] {
	#       Message "Run Command" "Can't run complex command. Open terminal please." 0
	#       return
	#}
	
	# Running "cd" command affects only to current panel
	if { [regexp {cd([ ]*)([^ ]*)} $command nul1 blanks dir ] } {
		
		if {[ string compare $dir "" ] == 0 } {
			cd
		} else {
			cd $dir
		}
		
  		if {[ string compare $settings(currentPane) left ] == 0 } {
  	  		set settings(dirLeft)  [pwd]
  	  		ReRead left
  		} else {
  	  		set settings(dirRight) [pwd]
  	  		ReRead right
  		}
		
		.cmd delete 0 end
		return
	}
	
	incr commandIndex
	set window .runCommand$commandIndex
	
	if [ winfo exists $window ] {
		Message "Run Command" "Can't run command. Exit from previous, please." 1
		return
	}
	
	toplevel $window -bg $settings(color_bg)
	wm title $window "Running Command: $command"
	wm minsize $window 80 20
	
	# Create a text widget to log the a output 
	frame $window.t -bg $settings(color_bg)
	set log [text $window.t.log -width 80 -height 20 -borderwidth 2\
		-relief sunken -setgrid true -yscrollcommand "$window.t.scroll set"\
		-bg $settings(color_bg) -fg White\
		-font $settings(run_command_font) ]
		
	scrollbar $window.t.scroll -width 10\
		-command "$window.t.log yview" -bg $settings(color_bg)
	pack $window.t.scroll -side right -fill y
	pack $window.t.log -side left -fill both -expand true
	pack $window.t -side top -fill both -expand true
	
	if [catch {open "|$command"} input] {
		$log insert end $input\n
		$log see end
        } else {
        	fileevent $input readable Log 
        	#$log insert end $command\n
        }
        frame  $window.separator -borderwidth 0 -bg Black -height 1
	pack   $window.separator -side top -fill x -pady 2

        button $window.quit -text Exit -command "QuitCommand $window"\
                        -bg $settings(color_bg)
	pack   $window.quit -side bottom -pady 2
}

proc QuitCommand { commandWindow } {
	.cmd delete 0 end
	destroy $commandWindow
}

# Read and log output from the program 
proc Log {} {
	global input log
 	           
	if [eof $input] {
		catch {close $input}
        } else {
		gets $input line
		$log insert end $line\n
		$log see end
	}
}

# If listing mode is FULL, then separate name of file
proc ParseName { name } {
  global settings 
 	
  if { [string compare $settings(currentPane) "left" ] == 0 } {
      set full [string compare $settings(left_list)  "full" ]
  } else {
      set full [string compare $settings(right_list) "full" ]
  }
  
  set file ""
  
  if {[ string compare $name "..<up> " ] == 0 } {
         return "..<up>"
  } elseif { $full == 0 } {
	 regexp {([^ ]+)([ ]+)} $name nul1 file nul2
	 return $file
  } else {
  	return $name
  }
}  

proc ChooseListMode { which } {
   global settings pane
   
   toplevel   .clm -bg $settings(color_button)
   wm title   .clm "Choose listing mode"
   wm minsize .clm 270 90
   wm maxsize .clm 270 90
   
   set pane $which  
   button .clm.f -text Full  -command { ChoosedListMode full  }\
   	-bg $settings(color_button)
   button .clm.b -text Brief -command { ChoosedListMode brief }\
   	-bg $settings(color_button)
   pack .clm.f .clm.b -side left -padx 10 -pady 5 -expand true
}

proc ChoosedListMode { mode } {
	global settings pane
	
	if { [ string compare $pane "left" ] == 0 } {
		set settings(left_list)  $mode
	} else {
		set settings(right_list) $mode
	}
	
	destroy .clm
	ReRead $pane
}

proc LevelUp { which } {
	global settings
	
	if { [ string compare $which "left" ] == 0 } {
		regexp {([^ ]*)/([^ /]*)} $settings(dirLeft) a b
		if { [ string compare $b "" ] == 0 } {
		        set settings(dirLeft) "/"
		} else { 
		        set settings(dirLeft) $b 
		}
 	} else {
		regexp {([^ ]*)/([^ /]*)} $settings(dirRight) a b
		if { [ string compare $b "" ] == 0 } {
		        set settings(dirRight) "/"
		} else { 
		        set settings(dirRight) $b
		}
	}
	ReRead $which
}   

proc About {} {
  global settings

  MessageLong "About $settings(name)"\
  "\n               $settings(name) version $settings(version)\n\n\
  $settings(name) is an interactive file manipulation tool\n" 50 4 
}

# Functions called from bottom line or by pressing F?? keys
 
proc Help {} {
  global settings
  
  if [ file exists $settings(prog_path)/$settings(name).help ] {
  	source $settings(prog_path)/$settings(name).help
  } else {
  	Message "$settings(name) Help" "Can't find help file!" 1
  }
}

proc Menu {} {

  global settings commandMenu
  
  set menuFile "$settings(prog_path)/$settings(name).menu"
  
  if [ catch { open $menuFile r } menu ] {
  	  Message "$settings(name) Menu" "Can't open menu file!!!\n" 1
  } else {
    
    toplevel .menuWindow -bg $settings(color_bg)

    wm title   .menuWindow "$settings(name) Menu"
    wm minsize .menuWindow 30 10 
    
    frame .menuWindow.t -bg $settings(color_bg)
    
    listbox .menuWindow.t.list -bg $settings(color_bg) -fg White\
	-yscrollcommand [list .menuWindow.t.sy set]
    scrollbar .menuWindow.t.sy -orient vertical -width 10 -bg $settings(color_bg)\
		     -command [list .menuWindow.t.list  yview]
    pack .menuWindow.t.list -side left -padx 5 -pady 5 -fill both -expand true
    pack .menuWindow.t.sy -side left -fill y
    	      
    while { [ gets $menu line ] >= 0 } {
      if [regexp {#\*([.]*)} $line nul ] {
           # this is comments
           continue
      } elseif [regexp {([^:]*):([^:]*)} $line nul menuItem command ] {
  	   .menuWindow.t.list insert end $menuItem
  	   set commandMenu($menuItem) $command
      }
    }
    
    pack .menuWindow.t -side top -fill both -expand true

    #frame .menuWindow.separator -borderwidth 0 -bg Black -height 1
    #pack  .menuWindow.separator -side top -fill x

    button .menuWindow.quit -text Quit -command { QuitTopLevel .menuWindow }\
    			       -bg $settings(color_bg)
    pack .menuWindow.quit -side bottom -padx 5 -pady 10

    bind .menuWindow <Escape>	 { QuitTopLevel .menuWindow }
    bind .menuWindow <Control-c> { QuitTopLevel .menuWindow }
    bind .menuWindow.t.list  <Return>          RunFromMenu
    bind .menuWindow.t.list  <Double-Button-1> RunFromMenu

  }
}

proc RunFromMenu {} {
  global commandMenu

  set runItem [ .menuWindow.t.list get active ]
  #QuitTopLevel .menuWindow
  #exec $commandMenu($runItem) &
  open "|$commandMenu($runItem)"
}

proc View {} { 
  global settings

  if {[ string compare $settings(currentPane) left ] == 0 } {
  	  set viewItem $settings(dirLeft)/[ ParseName [.lists.l.left get active ]]
  } else {
  	  set viewItem $settings(dirRight)/[ ParseName [.lists.r.right get active ]]
  }
  
  if [file isfile $viewItem ] {
  	open "|$settings(viewer) $viewItem"
 	 #exec $settings(viewer1) $settings(viewer2) $settings(viewer3) $viewItem &
  } else {
  	Message "View" "Can't edit $viewItem. It is not a file." 1
  }
 	 
}

proc Edit {} {
  global settings

  if {[ string compare $settings(currentPane) left ] == 0 } {
  	  set editItem $settings(dirLeft)/[ ParseName [.lists.l.left get active ]]
  } else {
  	  set editItem $settings(dirRight)/[ ParseName [.lists.r.right get active ]]
  }
  
  if [file isfile $editItem ] {
  	exec $settings(editor) $editItem &
  } else {
  	Message "Edit" "Can't edit $editItem. It is not a file." 1
  }
	
  ReRead left
  ReRead right
}

proc Copy {} {
  global settings answerYesNo

  if {[ string compare $settings(currentPane) left ] == 0 } {
  	cd  $settings(dirLeft)
  	set from $settings(dirLeft)
  	set to   $settings(dirRight)
  	set list .lists.l.left
  } else {
  	cd  $settings(dirRight)
 	set from $settings(dirRight)
  	set to   $settings(dirLeft)
  	set list .lists.r.right
  }
  
  set selList [ $list curselection ]
  	  
  foreach index $selList  {
  	  set copyItem [ ParseName [ $list get $index ]]
  	  if [ file isdirectory $from/$copyItem ] {
  		  Message "Copy" "$settings(name) can't copy directory. Sorry..." 0
  	  } elseif [ file isfile $from/$copyItem ] {
  	  	if [ file exists $to/$copyItem ] {
  	  		
  	  		YesNo "Copy" "File $to/$copyItem exists. Overwrite?" 0
  	  	  	tkwait window .yesnoWindow
  	  	  	
  	  	  	if { $answerYesNo == 1 } {
  		  		exec cp $from/$copyItem $to
  		  	}
  		  	
  		} else {
  			exec cp $from/$copyItem $to
  		}
  	  } else {
 		Message "Copy" "Can't copy $from/$copyItem. File is not exist." 1
  	  }
  }

  ReRead left
  ReRead right 
}

proc MoveTo {} {
	global answer answerYesNo moveFrom
	
   	#if [ file isdirectory $moveFrom ] {
  	#	Message "Move/Rename" "$settings(name) can't move directory. Sorry..." 0
  	#} else
  	if [ file exists $moveFrom ] {
  	
  		if [ file exists $answer ] {
  			YesNo "Move/Rename" "File $answer exists. Overwrite?" 0
  			tkwait window .yesnoWindow
  			
  	  	  	if { $answerYesNo == 1 } {
  		  		exec mv $moveFrom $answer
  		  	}
  		  	
  		} else {
  			exec mv $moveFrom $answer
  		}
   	} 
}

proc Move {} {
  global settings moveFrom modeDialog answer

  if {[ string compare $settings(currentPane) left ] == 0 } {
  	  cd  $settings(dirLeft)
  	  set from $settings(dirLeft)
  	  set to   $settings(dirRight)
  	  set list .lists.l.left
  } else {
          cd  $settings(dirRight)
 	  set from $settings(dirRight)
  	  set to   $settings(dirLeft)
  	  set list .lists.r.right
  }
  
  set selList [ $list curselection ]
  set modeDialog 0
 	  
  foreach index $selList  {
  
        set moveItem [ ParseName [ $list get $index ]]
        set moveFrom $from/$moveItem
        set moveTo   $to/$moveItem
   
    if { $modeDialog == 0 } {
        if [ file exists $moveFrom ] {
        	Dialog "Move/Rename" "Move/Rename  $moveItem  To:" $moveTo MoveTo 1
        	tkwait window .questWindow
        } else {
 		Message "Move/Rename" "Can't move/rename $moveFrom. File is not exist." 1
  	}
    } elseif { $modeDialog == 2 } {
        set answer $moveTo
        MoveTo
    }
  } 

  ReRead left
  ReRead right 
}


proc MkDir {} {
	global settings answer
	
	if {[ string compare $settings(currentPane) left ] == 0 } {
	   if { [ file exists $settings(dirLeft)/$answer ] } {
	   	Message "Make Directory" "Directory $settings(dirLeft)/$answer exists." 1
	   } else {
		exec mkdir $settings(dirLeft)/$answer
		ReRead left
	   }
	} else {
	   if { [ file exists $settings(dirRight)/$answer ] } {
	   	Message "Make Directory" "Directory $settings(dirRight)/$answer exists." 1
	   } else {
		exec mkdir $settings(dirRight)/$answer
		ReRead right
	   }
	}
}

proc Delete {} {
	global settings answerYesNo
	
 	set yesToAll 0
 	
	if { [ string compare $settings(currentPane) "left" ] == 0 } {
	   set list .lists.l.left
	   set dir  $settings(dirLeft)
	} else {
	   set list .lists.r.right
	   set dir  $settings(dirRight)  
	}
 	
 	set delList [ $list curselection ]
 	foreach index $delList  {
	     set delItem $dir/[ ParseName [ $list get $index ]] 
   	     if [ file isdirectory $delItem ] {
  		#Message "Delete" "$settings(name) can't delete directory. Sorry..." 0
 	     	
  	     	YesNo "Delete Directory"\
  	     	      "Are you sure to delete directory $delItem with all files ?" 3
	     	tkwait window .yesnoWindow
	     	
	     	set opt "-Rf"
	     	if { $answerYesNo == 1 || $answerYesNo == 2 } {
	     		exec rm $opt $delItem
	     	}
  	     } elseif [ file exists $delItem ] {
  	     	     
  	     	if { $yesToAll == 0 } {
  	     	     YesNo "Delete File" "Are you sure to delete $delItem ?" 1
	     	     tkwait window .yesnoWindow
	     	     if { $answerYesNo == 1 } {
	     		     exec rm $delItem
	     	     } elseif { $answerYesNo == 2 } {
	     		     exec rm $delItem
	     		     set  yesToAll 1
	     	     }
	     	} elseif { $yesToAll == 1 } {
	     		     exec rm $delItem
	     	}
  	     }
	}
	
	if {[ string compare $settings(currentPane) left ] == 0 } {
		ReRead left 
	} else {
		ReRead right 
	}
	
}

proc RunTerm {} {
     global env settings  
     
     if {[ string compare $settings(currentPane) left ] == 0 } {
	set dir $settings(dirLeft)
     } else {
     	set dir $settings(dirRight)
     }
     cd $dir 
     exec $settings(terminal) &
}

proc Quit {} {
	#global env
	
	#if [ file exists  "$env(HOME)/.Fedot" ] {
	#	exec rm -Rf "$env(HOME)/.Fedot/*" 
	#}
	exit
}

# See for existing of action by extension
proc ExistActionForExtension { file } {
	global extensions
	
	set ext ""
	
	regexp {([^ ]*)\.([^\.]+)} $file all file ext
	
	if { [ string compare $ext "" ] == 0 } { return 0 }
	set listExt [array names extensions ]
	
	if { [lsearch -exact $listExt $ext ] >= 0 } { 
		return 1 
	}
	
	return 0
}

proc RunActionByExtension { file } {
	global extensions
	puts runaction
	
	regexp {([^ ]*)\.([^\.]*)} $file all name ext
	
	if { [ string compare $ext "" ] == 0 } { return 0 }
	set listExt [array names extensions ]
	 
	if { [lsearch -exact $listExt $ext ] >= 0 } { 
	     exec $extensions($ext) $file
	}
	
	return 0
}

proc GZipView { fullPath runItem } {
	global command env

	if { ![ file exists  "$env(HOME)/.Fedot" ] || \
	     ![ file isdirectory "$env(HOME)/.Fedot" ] } {
	        Message "Fedot: view *.tar.gz" "Directory .Fedot created in you home." 0
	        tkwait window .messageWindow
		exec mkdir "$env(HOME)/.Fedot"
	}
	puts 1
	exec rm -Rf "$env(HOME)/.Fedot/*" 
	puts 2
	exec cp $fullPath "$env(HOME)/.Fedot/"
	puts 3
	exec gzip -d "$env(HOME)/.Fedot/$runItem"
	puts 4  
	set command "tar -tf $env(HOME)/.Fedot/*.tar"
	puts 5
	Run
}

# Pressing < Return > on list item:
# 1.Change directory OR
# 2.Execute OR
# 3.Find action by extension
# 
proc RunItem {} {
	global settings command
	
	if { [ string compare $settings(currentPane) "left" ] == 0 } {
	        
		set runItem [ ParseName [.lists.l.left get active ]]
		
		if { [ string compare $runItem "..<up>" ] == 0 } {
		       regexp {([^ ]*)/([^ /]*)} $settings(dirLeft) a b
		       if { [ string compare $b "" ] == 0 } {
		       		set settings(dirLeft) "/"
		       } else { 
		       		set settings(dirLeft) $b 
		       }
		       ReRead left
		} elseif [ file isdirectory "$settings(dirLeft)/$runItem" ] {
			if { [ string compare $settings(dirLeft) "/" ] == 0 } {
	        		set settings(dirLeft) "/$runItem"
	        	} else { 
	        		set settings(dirLeft) "$settings(dirLeft)/$runItem"
	        	}
		        ReRead left
		} elseif [ file executable "$settings(dirLeft)/$runItem" ] {
			exec "$settings(dirLeft)/$runItem" 
		} elseif { [ file isfile "$settings(dirLeft)/$runItem" ] && \
		           [ ExistActionForExtension $runItem ] == 1 } {
		 	RunActionByExtension $settings(dirLeft)/$runItem 
		} elseif { [ file isfile "$settings(dirLeft)/$runItem" ] && \
		           [ string match {*.tar} $runItem ] } {  # for tared files
		        set command "tar -tf $runItem"
		        Run  
		}
	} else {
		set runItem [ ParseName [.lists.r.right get active]]
		
		if {[ string compare $runItem "..<up>" ] == 0 } {
			regexp {([^ ]*)/([^ /]*)} $settings(dirRight) a b
		        if { [ string compare $b "" ] == 0 } {
		       		set settings(dirRight) "/"
		        } else { 
				set settings(dirRight) $b
			}
			ReRead right
		} elseif [ file isdirectory "$settings(dirRight)/$runItem" ] {
		        if { [ string compare $settings(dirRight) "/" ] == 0 } {
		        	set settings(dirRight) "/$runItem"
		        } else {
		        	set settings(dirRight) "$settings(dirRight)/$runItem"
		        }
		        ReRead right
		} elseif [ file executable "$settings(dirRight)/$runItem" ] {
			exec "$settings(dirRight)/$runItem" 
		} elseif { [ file isfile "$settings(dirRight)/$runItem" ] && \
		           [ ExistActionForExtension $runItem ] == 1 } {
		 	RunActionByExtension $settings(dirRight)/$runItem 
		} elseif { [ file isfile "$settings(dirRight)/$runItem" ] && \
		           [ string match {*.tar} $runItem ] } {  # for tared files
		        set command "tar -tf $runItem"
		        Run 
		}
		#} elseif { [ file isfile "$settings(dirRight)/$runItem" ] && \
		#           [ string match {*.tar.gz} $runItem ] } {  # for tar-gzipped files
		#        GZipView $settings(dirRight)/$runItem $runItem
	
	}
}

# Insert was pressed on list's item 
proc MarkItem {} {
	global settings answer 
	
	if { [ string compare $settings(currentPane) "left" ] == 0 } {
		set list .lists.l.left
	} else {
		set list .lists.r.right
	}
	
	set curr [ $list index active ]
	if [ $list select includes $curr ] {
		$list select clear $curr
	} else {
		$list select set $curr
	}
	
	incr curr
	$list activate $curr
}

# Plus or GrayPlus was pressed on list's item
proc SelectFilesAct {} {
 	global settings answer
 	
	if { [ string compare $settings(currentPane) "left" ] == 0 } {
		set list .lists.l.left
	} else {
		set list .lists.r.right
	}
	
	set last [ $list index end ]
	for { set i 0 } { $i <= $last } { incr i } {
		if [ string match $answer [ ParseName [ $list get $i ]]] {
			$list select set $i
  		}
	}
}

proc SelectFiles {} {
	global settings
	
	if { [ string compare $settings(currentPane) "left" ] == 0 } {
		set list .lists.l.left
	} else {
		set list .lists.r.right
	}
	
       	Dialog "Select Files" "Enter mask to select files:" "*" SelectFilesAct 0
        tkwait window .questWindow
}

# Minus or GrayMnus was pressed on list's item
proc UnSelectFiles {} {
	global settings answerYesNo

	if { [ string compare $settings(currentPane) "left" ] == 0 } {
		set list .lists.l.left
	} else {
		set list .lists.r.right
	}
	
 	YesNo "Unselect Files" "Unselect all files in current directory?" 0
  	tkwait window .yesnoWindow
  	
  	if { $answerYesNo == 1 } {
		$list select clear 0 end
  	}

}

proc EditUserPreferences {} {
	global settings fedotPath
		
	set confFile "$settings(prog_path)/$settings(name).conf"
	
	exec $settings(editor) $confFile 
	SetUserPreferences $fedotPath
	
	ToLeft
	ReRead left
	ToRight
	ReRead right
	ToLeft
}

proc EditUserMenu {} {
	global settings
	
	set menuFile "$settings(prog_path)/$settings(name).menu"
	
	exec $settings(editor) $menuFile &
}

proc EditExtAssociations {} {
	global settings
	
	set extFile "$settings(prog_path)/$settings(name).ext"
	
	exec $settings(editor) $extFile &
}

# <Control-Return> pressed on list item
proc AddFileToComm { which } {
	global settings command

	if { [ string compare $which "left" ] == 0 } {
		set list .lists.l.left
	} else {
		set list .lists.r.right
	}
	set item [ ParseName [ $list get active]]
	
	.cmd insert end " $item"
}

##        	
        		 
         
