/*
 * Motif_look.c
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 *
 * $Id:$
 *
 */
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PanedW.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <map+_cfg.h>
#include <maprusers.h>
#include <bad_host.h>
#include <config.h>

#include <Motif_look.h>
#include <cat_text.h>
#include <menu.h>
#include <info.h>

#define SIZE_BUF 1024

typedef struct bad_host_t *bad_tmp;

extern data_internal_t list_host;
extern  bad_tmp bad_host;
extern int go(char *name, config_file_t  config_data );

/* Flying menu */
Widget *flying;

static Widget *host_label, 
              *name_liste,
              *row_c, 
              pane,
              current_list,
              toplevel;

static        XtAppContext app;

static int     people_int,
               current_int,
               number_host;

static        config_file_t cfg;


static void cb_list(Widget w, XtPointer client_data, 
                    XmListCallbackStruct *cbs);
static char *write_text(char *buf, char *text, size_t size);


void set_number_host(int nb)
{
    number_host = nb;
}

/* Actions */
void cb_rlogin(Widget w, int item_no)
{
  char buf[1024];
            
    sprintf(buf, "%s %s %s &", XTERM, RLOGIN,
            get_name_host(list_host, current_int));
    
    system(buf);
}

void cb_talk(Widget w, int item_no)
{
    char buf[1024];
    
    sprintf(buf, "%s %s %s@%s &", XTERM, TALK, 
            get_name_login(list_host,current_int,people_int),
            get_name_host(list_host, current_int));
    
    system(buf);
}


void cb_finger(Widget w, int item_no)
{
    char   buf[SIZE_BUF];
    int    pipe_map[2];
    int    size_read;
    int    file_res;
    char  *name_res;
    char  *finger_text=NULL;
    
    pid_t  pid;
    
    /* make the pipe */
    if (pipe(pipe_map) == -1)
    {
        fprintf(stderr, " Unable to open a pipe \n");
        return;
    }

    switch (pid=fork())
    {
        case -1: /* Error */
            fprintf(stderr, " Unable to fork\n");
            close(pipe_map[0]);
            close(pipe_map[1]);            
            return;
        break;
            
        case 0: /* Son */

            close(pipe_map[0]);

            if(dup2(pipe_map[1], 1) < 0) 
            {
                close(pipe_map[1]);
                fprintf(stderr, "dup2() failed: %s\n", strerror(errno));
                exit(-1);
            }

            sprintf(buf, "%s@%s", 
                    get_name_login(list_host,current_int,people_int),
                    get_name_host(list_host, current_int));

            /* exec a finger -l name@host */
            if(execlp(FINGER, FINGER, ARG_FINGER, buf, NULL) == -1) 
            {
                close(pipe_map[1]);
                fprintf(stderr, "Failed to execlp(): %s\n", strerror(errno));
                exit(-1);
            }
        break;
            
        default : /* father */
            close(pipe_map[1]);
            name_res = malloc(sizeof(char)*SIZE_BUF);
            strcpy(name_res, "XXXXXX");
            
            /* creat tmp file */
            name_res = mktemp(name_res);
            file_res = open(name_res, O_RDWR | O_CREAT, 0644);
            
            /* Read header */
            while((size_read=read(pipe_map[0], buf,SIZE_BUF ))==SIZE_BUF)
                finger_text = write_text(finger_text, buf, SIZE_BUF);

            if ((size_read != SIZE_BUF) && (size_read))
                finger_text = write_text(finger_text, buf, size_read);

            /* Text */
            while((size_read=read(pipe_map[0], buf,SIZE_BUF ))==SIZE_BUF)
                finger_text = write_text(finger_text, buf, SIZE_BUF);

            if ((size_read != SIZE_BUF) && (size_read))
                finger_text = write_text(finger_text, buf, size_read);
            
            close(file_res);
            /* destroy tmp file */
            unlink(name_res);
            free(name_res);
            
            cat_text(w, finger_text, "Finger");
            free(finger_text);

            break;
            }
}

void run_display(int nb, Widget pane)
{
    int           k,i, indice = 0;
    char          buf[512];
    XmString      host;
    XmStringTable str_list;
    long          bgcolor=-1;

    XtVaSetValues(pane, XmNnumColumns, 
                  get_rusers_height(list_host) , NULL);

    /* Just to get the nackground color */
    row_c[0] = XtVaCreateWidget(buf,
                                xmRowColumnWidgetClass, pane, NULL);
    XtManageChild(row_c[0]);
    XtVaGetValues(row_c[0], XmNbackground, &bgcolor,NULL);
    XtDestroyWidget(row_c[0]);
    
    for (k = 0; k < nb; k++)
    { 
        sprintf(buf, "%s%d", "rowcol",k);                
        row_c[k] = XtVaCreateWidget(buf,
                                    xmRowColumnWidgetClass, pane, NULL);
        XtManageChild(row_c[k]);

        if (get_bad_host_val(k) > 0) /* Station */
        {
            int bad = 0;

            host = XmStringCreateSimple(get_name_host(list_host,indice));
            host_label[k] = XtVaCreateManagedWidget("label",
                                              xmLabelWidgetClass, row_c[k],
                                              XmNlabelString, host,
                                              NULL); 

            if (get_nb_login(list_host, indice) == 0) /* Nobody on */
            {
                str_list = (XmStringTable) XtMalloc(sizeof(XmString *));
                str_list[0] = XmStringCreateSimple("->NONE<-");
                set_nb_login(list_host,indice,1);
                bad = 1;
            }
            else
            {
                str_list = (XmStringTable) XtMalloc(sizeof(XmString *)*
                                              get_nb_login(list_host,indice));
                
                for (i = 0; i < get_nb_login(list_host,indice) ; i++)
                    str_list[i] = XmStringCreateSimple(
                                        get_name_login(list_host,indice,i));
            }

            name_liste[k] = XmCreateScrolledList(row_c[k], "Names",NULL,0);

            XtVaSetValues(name_liste[k], 
                          XmNshadowType, XmSHADOW_IN,
                          XmNtopAttachment,10,
                          XmNitemCount,get_nb_login(list_host,indice), 
                          XmNvisibleItemCount, 5,
                          XmNitems, str_list,
                          NULL);

            if (!bad) 
                XtAddCallback(name_liste[k],
                              XmNbrowseSelectionCallback,
                              (XtCallbackProc)cb_list, (XtPointer)indice);
            else 
                XtAddCallback(name_liste[k],
                              XmNbrowseSelectionCallback,
                              (XtCallbackProc)cb_list, (XtPointer)(- indice));

            XtManageChild(name_liste[k]); 
            
            for (i=0;i<get_nb_login(list_host,indice) ; i++) 
                XmStringFree(str_list[i]);

            XtFree((char *)str_list);  
            
            indice++;
        }
        else
        {
            if (get_bad_host_val(k) == 0) /* Can't connect */
            {
                host = XmStringCreateSimple(get_bad_host_ptr(k));
                
                host_label[k] = XtVaCreateManagedWidget("label",
                                              xmLabelWidgetClass, row_c[k],
                                              XmNlabelString, host,
                                              NULL); 

                str_list = (XmStringTable) XtMalloc(sizeof(XmString *));
                str_list[0] = XmStringCreateSimple("??????");

                name_liste[k] = XmCreateScrolledList(row_c[k], "Names",NULL,0);
                XtVaSetValues(name_liste[k], 
                          XmNshadowType, XmSHADOW_IN,
                          XmNtopAttachment,10,
                          XmNitemCount,1,
                          XmNvisibleItemCount, 5,
                          XmNitems, str_list,
                          NULL);

                XtManageChild(name_liste[k]);             
                XmStringFree(str_list[0]);

                XtFree((char *)str_list);  
            }                
            else
            { /* Empty place */
                host = XmStringCreateSimple("");
                host_label[k] = XtVaCreateManagedWidget("label",
                                              xmLabelWidgetClass, row_c[k],
                                              XmNlabelString, host,
                                              XmNbackground, bgcolor,
                                                        NULL); 
                XtManageChild(host_label[k]); 
            }
        }            
    }
}    

void init_interface(int argc, char **argv, config_file_t config_data)
{
	Widget main_w, menu_bar;

    cfg = config_data;

    /* Initialize toolkit and parse command line options. */
    toplevel = XtVaAppInitialize(&app, "map+",
                      NULL, 0, &argc, argv, NULL, NULL);

    main_w = XtVaCreateManagedWidget("main_window",
        xmMainWindowWidgetClass,   toplevel,
        XmNscrollBarDisplayPolicy, XmAS_NEEDED,
        XmNscrollingPolicy,        XmAUTOMATIC, 
        NULL); 

    menu_bar = init_popup_menu(main_w, config_data);

    pane = XtVaCreateWidget("rowcol",
             xmRowColumnWidgetClass, main_w,
             XmNpacking,     XmPACK_COLUMN,
             XmNorientation, XmHORIZONTAL,
             NULL);
}

void run_interface(int nb)
{
    run_display(nb, pane); 
    XtManageChild(pane);

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
}

/* Free all the currents */
void destroy_current(void)
{
    int i;
    
    for (i = 0 ; i < number_host ; i++)
    {
        if (get_bad_host_val(i) >= 0)
        {
            XtUnmanageChild(name_liste[i]);
            XtDestroyWidget(name_liste[i]);
        }

        XtUnmanageChild(host_label[i]);
        XtDestroyWidget(host_label[i]);

        XtUnmanageChild(row_c[i]);
        XtDestroyWidget(row_c[i]);
    }
    
    free(host_label);
    free(name_liste);
    free(row_c); 
}

/* Popup menu... a lot of options :-) */
void action_file(Widget w, int item_no)
{
    switch (item_no)
    {
        case QUIT:
           exit(0);
    }
}

void action_place(Widget w, int item_no)
{
    int nb;

    XtUnmanageChild(pane);
    destroy_current();
    delete_host_list(list_host);

    nb = go(get_name_room(cfg, item_no), cfg);

    run_display(nb, pane);
    XtManageChild(pane);
}


void alloc_widgets(int nb)
{
    host_label = malloc(sizeof(Widget) * nb);
    name_liste = malloc(sizeof(Widget) * nb);
    row_c      = malloc(sizeof(Widget) * nb); 
}

/* When you click on the popup menu */
static void cb_list(Widget w, XtPointer client_data, 
                            XmListCallbackStruct *cbs)
{
    int nb = (int)client_data;    

    current_list = w;

    if (nb < 0)
    {
        XtSetSensitive( flying[3], False);
        XtSetSensitive( flying[4], False);
        current_int = -nb;
    }
    else
    {
        XtSetSensitive(flying[3], True);
        XtSetSensitive(flying[4], True);
        people_int   = cbs->item_position - 1;
        current_int  = nb;
        update_info(list_host, nb, people_int);
    }

    /* This is not a click event */
    if (!cbs->event)
        return;

    XmMenuPosition(flying[0], (XButtonPressedEvent *)cbs->event);
    XtManageChild (flying[0]);    
}

static char *write_text(char *buf, char *text, size_t size)
{
    static size_t cur_size = 0;
    
    if (!cur_size)
    {
        buf = malloc(sizeof(char)*(size + 1));
        strncpy(buf, text, size);
        buf[size] = '\0';
        cur_size += size;
    }
    else
    {
        buf = realloc(buf, sizeof(char)*(size + cur_size));
        strncat(buf, text, size);
        cur_size += size;
        buf[cur_size] = '\0';
    }

    return buf;    
}
