/*
 * info.c
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 *
 * $Id:$
 *
 */
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>

#include <stdio.h>
#include <stdlib.h>

#include <info.h>
#include <xmisc.h>

#include <maprusers.h>

#define SET_LABEL_VALUE(name, text)                                 \
    MyString = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);  \
    XtVaSetValues(name, XmNlabelString, MyString, NULL);            \
    XmStringFree(MyString)   

#define CREATE_LABEL(name, father)     \
     XtVaCreateManagedWidget(name,     \
            xmLabelGadgetClass, father,\
                        NULL)

#define ACREATE_LABEL(name, val, father)                     \
     SET_LABEL_VALUE(XtVaCreateManagedWidget(name,          \
                            xmLabelGadgetClass, father,     \
                            NULL),val)

static Widget host, nb, user, date, idle, remote, local;
static Widget dialog = NULL;

static void cb_popdown_shell(Widget w, XtPointer client_data, 
                             XtPointer call_data);

void info_prog(Widget w)
{
    Widget pane, bt_close;
    
    XmString MyString;

    if (dialog != NULL)
        return;
    
    dialog =XtVaCreatePopupShell("Info",
                       xmDialogShellWidgetClass, GetTopShell(w),
                       NULL);
    
    pane = XmCreateForm( dialog, "InfoForm", NULL, 0);
    XtManageChild(pane);

    ACREATE_LABEL("Hostname", "Hostname :",pane);
    ACREATE_LABEL("Nb_people", "Nb people :",pane);
    ACREATE_LABEL("User_Name", "Logname :", pane);
    ACREATE_LABEL("date", "Date login : ",pane);
    ACREATE_LABEL("idle_time","Idle Time :", pane);
    ACREATE_LABEL("remote", "Remote Host :",pane);
    ACREATE_LABEL("local", "Device : ",pane);


    host   = CREATE_LABEL("host_text", pane);
    nb     = CREATE_LABEL("nb_text", pane);
    user   = CREATE_LABEL("user_text", pane);
    date   = CREATE_LABEL("date_text", pane);
    idle   = CREATE_LABEL("idle_text", pane);
    remote = CREATE_LABEL("remote_text", pane);
    local  = CREATE_LABEL("local_text", pane);

    bt_close = XtVaCreateManagedWidget("Info_Ok_button", 
                                       xmPushButtonWidgetClass,
                                       pane,
                                       NULL);
    XtAddCallback(bt_close, XmNactivateCallback, cb_popdown_shell,
                  dialog);

    XtVaCreateManagedWidget("Separator_Info", 
                                  xmSeparatorWidgetClass, pane,
                                  NULL); 

    XtPopup(dialog, XtGrabExclusive);
}

void update_info(data_internal_t host_array, int host_n, int login_n)
{
    XmString MyString;    
    char tmp[50];

    if (dialog ==NULL)
        return;
    
    SET_LABEL_VALUE(host, get_name_host(host_array, host_n));

    sprintf(tmp, "%d", get_nb_login(host_array, host_n));
    SET_LABEL_VALUE(nb, tmp);
    
    SET_LABEL_VALUE(user, get_name_login(host_array, host_n, login_n));
    SET_LABEL_VALUE(date, get_date(host_array, host_n, login_n));
    SET_LABEL_VALUE(idle, get_idle_time(host_array, host_n, login_n));
    SET_LABEL_VALUE(remote, get_remote(host_array, host_n, login_n));
    SET_LABEL_VALUE(local, get_local(host_array, host_n, login_n));
}


static void cb_popdown_shell(Widget w, XtPointer client_data, 
                             XtPointer call_data)
{
     Widget topshell = (Widget) client_data;

     XtPopdown(topshell);

     dialog = NULL;
     
}
