/* 
 * menu.c
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 * $Id: menu.c,v 1.3 1995/04/13 22:46:46 dumas Exp dumas $
 * the Build_Menu function has been designed by :
*/

/* 
 * Copyright 1993, 1994 Liverpool University Computer Science Department
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of L.U.C.S. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. L.U.C.S. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * FILE NAME:   XbrMenu.c
 * CREATED:     Mon Nov  1 1993
 * AUTHOR:      Rik Turnbull (rik@csc.liv.ac.uk)
 * DESCRIPTION: Routine for creating popup or pulldown menus.
 *
 */

/*
 * E.D. : adding the mnemonic and accelerators operations.
 */

#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>

#include <stdlib.h>
#include <stdio.h>

#include <menu.h>
#include <about.h>
#include <info.h>
#include <config.h>

#define MENU            0
#define CASCADE         1

#define DEF_MENU_POPUP           1
#define DEF_MENU_PULLDOWN        2
#define DEF_MENU_PULLDOWN_RADIO  3
#define DEF_MENU_OPTION          4

#define DEF_LABEL                1
#define DEF_PB                   2
#define DEF_SEPARATOR            3
#define DEF_SUBMENU              4
#define DEF_TOGGLE               5

#define DEF_SET                  1
#define DEF_UNSET                0

typedef struct menu_data menu_data_t;
struct menu_data {
    int    type;                /* Type of widget 1 from 5 above      */
    char  *label;               /* Label for widget                   */
    char   mnemonic;            /* Mnemonic                           */
    char  *accel;               /* Accelerator                        */
    char  *accel_text;          /* to be converted to compound string */
    XtCallbackProc callback;    /* Callback to be added               */
    XtPointer data;             /* Data for callback                  */
    int    set;                 /* Set this (if toggle button)        */
    struct menu_data *submenu;  /* Possible submenu                   */
    char  *title;               /* Title for submenu                  */
    int    stype;               /* Type of submenu                    */
    int    n;                   /* Number of items in submenu         */
};

static Widget *Build_Menu(Widget parent, char *title, char mnemo, 
                          int menu_type,
                          menu_data_t menu_data[], int nb);

/* Menus declarations */
static menu_data_t flying_menu[] =
{
     {DEF_LABEL    , "MAP+ Action", 'M', NULL,NULL,
            (XtCallbackProc)     NULL, (XtPointer)0, 
           0, NULL, NULL, 0, 0},

     {DEF_SEPARATOR, NULL,0 ,NULL, NULL , NULL    

          , NULL, 0, NULL, NULL, 0, 0},
     {DEF_PB       , "Talk", 'T', "Ctrl<Key>T","Ctrl-T",
            (XtCallbackProc)     cb_talk, (XtPointer)0, 
           0, NULL, NULL, 0, 0},
     {DEF_PB       , "Finger", 'F', "Ctrl<Key>T","Ctrl-F",
            (XtCallbackProc)     cb_finger, (XtPointer)0, 
           0, NULL, NULL, 0, 0},
     {DEF_PB       , "Rlogin", 'R', "Ctrl<Key>R","Ctrl-R",
            (XtCallbackProc)     cb_rlogin, (XtPointer)0, 
           0, NULL, NULL, 0, 0},
 };

static menu_data_t map_file_menu[] =
{
     {DEF_PB       , "Quit", 'Q', "Ctrl<Key>Q","Ctrl-Q",
            (XtCallbackProc)     action_file, (XtPointer)QUIT, 
           0, NULL, NULL, 0, 0},
};

static menu_data_t *map_show_menu = NULL;

static menu_data_t map_info_menu[] =
{
     {DEF_PB       , "Informations", 'I', "Ctrl<Key>I","Ctrl-I",
         (XtCallbackProc)     info_prog, NULL, 
           0, NULL, NULL, 0, 0},
};

static menu_data_t map_help_menu[] =
{
     {DEF_PB, "About this Application...", 'A', NULL, NULL,
            (XtCallbackProc)    about_prog , NULL, 0, NULL, NULL, 0, 0},
};
/* End of menu declaration */

extern Widget *flying;

Widget init_popup_menu(Widget main_w, config_file_t cfg)
{
    Widget   *map_menu, 
             *map_s_menu, 
             *map_h_menu;
    int i;
    char tmp[20];

    Widget menubar;

    flying =  Build_Menu( main_w, "Flying Menu", 'F', 
                         DEF_MENU_POPUP,
                         flying_menu, 
                         XtNumber(flying_menu));

    menubar = XmCreateMenuBar(main_w, "MenuBar", NULL,0);
    XtManageChild(menubar);

    map_menu = Build_Menu( menubar, "File", 'F', DEF_MENU_PULLDOWN,
                          map_file_menu, XtNumber(map_file_menu));

    map_show_menu = malloc(get_nb_room(cfg) * sizeof(struct menu_data));
    
    for (i = 0; i < get_nb_room(cfg) ; i++)
    {
        map_show_menu[i].type = DEF_PB;
        map_show_menu[i].label = strdup(get_name_room(cfg,i));

        map_show_menu[i].mnemonic = 0;

        sprintf(tmp, "Ctrl<Key>%d", i);
        map_show_menu[i].accel = strdup(tmp);

        sprintf(tmp, "Ctrl-%d", i);
        map_show_menu[i].accel_text = strdup(tmp);
        
        map_show_menu[i].callback = (XtCallbackProc)action_place;
        map_show_menu[i].data = (XtPointer)i;
        map_show_menu[i].set = 0;
        map_show_menu[i].submenu= NULL;
        map_show_menu[i].title = NULL;
        map_show_menu[i].stype = 0;
        map_show_menu[i].n = 0;
    }        

    map_s_menu = Build_Menu(menubar, "Place", 'P', DEF_MENU_PULLDOWN,
                          map_show_menu, get_nb_room(cfg)); 

    Build_Menu(menubar, "Info", 'I', DEF_MENU_PULLDOWN,
               map_info_menu, XtNumber(map_info_menu)); 

    map_h_menu = Build_Menu(menubar, "Help", 'H', DEF_MENU_PULLDOWN,
                          map_help_menu, XtNumber(map_help_menu)); 

    XtVaSetValues(menubar, XmNmenuHelpWidget, map_h_menu[1], NULL);

    return menubar;
}  

Widget *Build_Menu(Widget parent, char *title, char mnemonic,
                   int menu_type,
                   menu_data_t menu_data[], int nb)
{
    XtAppContext app_context     = XtWidgetToApplicationContext(parent);
    Widget      *widgets;
    Boolean      radio_behaviour = False;
    int          i, 
                 extras;
    
    Arg          args[10];
    Cardinal     num;
    XmString     string;

    /* Number of extra widgets to create - for a popup this is just the popup
       menu but for pulldowns there is the menu and the cascade button.*/

    if(menu_type == DEF_MENU_POPUP)
        extras = 1;
    else
        extras = 2; 
                      
    /* Allocate memory for widgets */
    if((widgets = (Widget *)malloc(sizeof(Widget) * (nb + extras)))==NULL) 
    {
        XtAppError(app_context, "Error - out of memory!\n");
        return(NULL);
    }

    /* Create menu */
    switch(menu_type) 
    {
        case DEF_MENU_POPUP:
            widgets[MENU] = XmCreatePopupMenu(parent, "MAP_Menu_Popup", 
                                              NULL, 0);
        break;

        case DEF_MENU_OPTION:
            widgets[MENU] = XmCreatePulldownMenu(parent, "MAP_Menu_Pane", 
                                                 NULL,0);
            num = 0; 
            string = XmStringCreateLocalized(title);
            XtSetArg(args[num], XmNsubMenuId  , widgets[MENU]); num++;
            XtSetArg(args[num], XmNlabelString, string); num++;
            widgets[CASCADE] = XmCreateOptionMenu(parent, 
                                               "MAP_Menu_Option",args,num);
            XmStringFree(string);
            XtManageChild(widgets[CASCADE]);
        break;

        case DEF_MENU_PULLDOWN_RADIO:
            radio_behaviour = True;
        case DEF_MENU_PULLDOWN:
            widgets[MENU] = XmCreatePulldownMenu(parent, 
                                                 "MAP_Menu_Pulldown", NULL,0);
            XtVaSetValues(widgets[MENU], XmNradioBehavior, radio_behaviour,
              NULL);

            /* Create menu title */
            widgets[CASCADE]  = XtVaCreateManagedWidget(NULL,
                          xmCascadeButtonWidgetClass, parent,
                          XmNsubMenuId, widgets[MENU],
                          XtVaTypedArg, XmNlabelString, XmRString,
                          title, sizeof(char *),
                          NULL);
            if (mnemonic)
                XtVaSetValues(widgets[CASCADE], XmNmnemonic, mnemonic,NULL);
        break;
        default:
            XtAppError(app_context, "Unknown menu type!\n");
    }

    /* Add desired widgets */
    for(i = 0; i < nb; i++) 
    {
        switch(menu_data[i].type) 
        {
            /* Label widget - easy */
            case DEF_LABEL:
                widgets[i+extras] = XtVaCreateManagedWidget(NULL,
                                        xmLabelWidgetClass, widgets[MENU],
                                        XtVaTypedArg, XmNlabelString, 
                                                            XmRString,
                                        menu_data[i].label, sizeof(char *),
                                        NULL);
            break;

            /* Push button gadget - include activate callback & data */
            case DEF_PB:
                widgets[i+extras] = XtVaCreateManagedWidget(NULL,
                          xmPushButtonWidgetClass, widgets[MENU],
                          XtVaTypedArg, XmNlabelString, XmRString,
                          menu_data[i].label, sizeof(char *),
                          NULL);

                if (menu_data[i].mnemonic)
                    XtVaSetValues(widgets[i+extras], XmNmnemonic,
                                  menu_data[i].mnemonic, NULL);

                if (menu_data[i].accel != NULL)
                {
                    XmString str = XmStringCreateSimple(
                                              menu_data[i].accel_text);
                    XtVaSetValues(widgets[i+extras], XmNaccelerator,
                                  menu_data[i].accel, XmNacceleratorText,str,
                                  NULL);
                }
                
                if(menu_data[i].callback != NULL)
                    XtAddCallback(widgets[i+extras], XmNactivateCallback,
                                  menu_data[i].callback, menu_data[i].data);

                if(menu_data[i].set && menu_type == DEF_MENU_OPTION)
                    XtVaSetValues(widgets[CASCADE], XmNmenuHistory, 
                                  widgets[i+extras], NULL);
            break;

            /* Toggle button - include value changed callback & data */
            case DEF_TOGGLE:
                widgets[i+extras] = XtVaCreateManagedWidget(NULL,
                        xmToggleButtonWidgetClass, widgets[MENU],
                        XtVaTypedArg, XmNlabelString, XmRString,
                        menu_data[i].label, sizeof(char *),
                        XmNindicatorType, XmONE_OF_MANY,
                        XmNset, menu_data[i].set,
                        NULL);

                if(menu_data[i].callback != NULL)
                    XtAddCallback(widgets[i+extras], XmNvalueChangedCallback,
                      menu_data[i].callback, menu_data[i].data);
            break;

            /* Separator to make menu look pretty! */
            case DEF_SEPARATOR:
                widgets[i+extras] = XtVaCreateManagedWidget(NULL,
                           xmSeparatorWidgetClass, widgets[MENU],
                          NULL);
            break;

            /* A sub menu */
            case DEF_SUBMENU:
            {
                Widget submenu;
                submenu = XmCreatePulldownMenu(widgets[MENU],
                                               menu_data[i].title,
                                               NULL, 0);

                widgets[i+extras] = XtVaCreateManagedWidget(NULL,
                       xmCascadeButtonWidgetClass, widgets[MENU],
                       XmNsubMenuId,                   submenu,
                       XtVaTypedArg, XmNlabelString, XmRString, 
                       menu_data[i].title,      sizeof(char *),
                       NULL);

                Build_Menu(submenu, menu_data[i].title, 
                           menu_data[i].mnemonic,
                           menu_data[i].stype,
                           menu_data[i].submenu, 
                           menu_data[i].n);
            break;
            }

            default:
                XtAppError(app_context, "Unknown menu item!\n");
            break;
        }
    }
    return(widgets);
}
