/*--------------------------------------------------------------------------------*\
| XtMacro.c: 11/01/95 (C) Raoul olivier                                             |
| description: functions for support XtMacro.h                                      |
\*--------------------------------------------------------------------------------*/

#include "XtMacro.h"
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <Xm/TextF.h>
#include <Xm/RowColumn.h>
#include <stdarg.h>
#include <Xm/PushB.h>
#include <stdio.h>
#include <Xm/Scale.h>
/*#include <malloc.h>*/
void	*malloc();
#include <X11/Xaw/Box.h>
#if XtSpecificationRelease>4
#include <X11/Xmu/Editres.h>
#endif

Widget stack[1000];

extern void  _XtVaToTypedArgList();
extern Widget _XtCreateWidget();
extern void _XtCountVaList();

int num_child=0;
void PushChild(Widget w,...)
{
  stack[num_child++]=w;
}
Widget GetChild()
{
  return(stack[num_child-1]);
}
void PullChild()
{
  num_child--;
}
int Nothing()
{
  return 0;
}
static Widget
_XtVaCreateWidget(name, widget_class, parent, var, count)
    String      name;
    WidgetClass widget_class;
    Widget      parent;
    va_list     var;
    int		count;
{
    register Widget         widget;
    void *	    typed_args = NULL;
    Cardinal		    num_args;

    _XtVaToTypedArgList(var, count, &typed_args, &num_args);

    widget = _XtCreateWidget(name, widget_class, parent, (ArgList)NULL, 
			     (Cardinal)0, typed_args, num_args);

    if (typed_args != NULL) {
        XtFree((XtPointer)typed_args);
    }    

    return widget;
}
Widget XtMacroCreateWidget(char* name,WidgetClass widget_class, ...)
{
    va_list		var;
    Widget	widget;
    int			total_count, typed_count;
    va_start(var,widget_class);
    _XtCountVaList(var, &total_count, &typed_count);
    va_end(var);
    
    va_start(var,widget_class);
    widget = _XtVaCreateWidget(name, widget_class, GetChild(), var, total_count);
    PushChild(widget);
    XtManageChild(widget);
    va_end(var);
    return widget;
 }

Widget XtMacroAppInitialize(XtAppContext* app_context_return /* app_context_return */,
			    String application_class/* application_class */,
			    XrmOptionDescList	options     /* options */,
			    Cardinal		num_options /* num_options */,
			    int*	        argc_in_out /* argc_in_out */,
			    String*		argv_in_out /* argv_in_out */,
			    String*	fallback_resources  /* fallback_resources */,
			    ...)
{
   va_list		var;
   Widget	widget;
   int			total_count, typed_count;
   va_start(var,fallback_resources);
   _XtCountVaList(var, &total_count, &typed_count);
   va_end(var);
   
   va_start(var,fallback_resources);
  widget = XtAppInitialize(app_context_return,
			   application_class,
			   options,
			   num_options,
			   argc_in_out,
			   argv_in_out,
			   fallback_resources,
			   var, total_count);
#if XtSpecificationRelease>4  
   XtAddEventHandler(widget, (EventMask) 0, TRUE, _XEditResCheckMessages, NULL);
#endif
   PushChild(widget);
   va_end(var);
   return widget;
}

void CallbackMethodProcess(Widget source,struct MethodData *data,XtPointer p)
{
  XtArgVal val;
  XtVaGetValues(source,data->ressrc,&val,NULL);
  XtVaSetValues(data->dest,data->resdst,val,NULL);
}
void
CallbackMethodDestroy(Widget source,struct MethodData *data,XtPointer p)
{
  free(data);
}
void 
DoMethod(Widget source,String callback,String ressrc,
	 Widget dest, String resdst)
{
  struct MethodData *data=(void *)malloc(sizeof(struct MethodData));
  data->dest=dest;
  data->ressrc=ressrc;
  data->resdst=resdst;
  XtAddCallback(source,callback,(void *)CallbackMethodProcess,data);
  XtAddCallback(source,XmNdestroyCallback,(void *)CallbackMethodDestroy,data);
}
void DoMethodDouble(Widget source,String callback,String ressrc,
	       Widget dest, String resdst)
{
  DoMethod(source,callback,ressrc,dest,resdst);
  DoMethod(dest,callback,ressrc,source,resdst);
}

