.TH "XTMACRO" "Xt" "Xt utilities" "" "Olivier RAOUL" 

.SH XTMACRO?
\fIXtMacro\fP provides a set of macros useful in interface
developpements. It allows you to design interfaces in a single expression.

.SH SYNOPSIS

APPINITIALIZE(app_context,class_name,options,num_options,argc,argv,
.br
fallbacks,...)
.br
XtAppContext *app_context;
.br
String class_name;
.br
XrmOptionDescList options;
.br
Cardinal num_options;
.br
Cardinal *argc;
.br
String *argv;
.br
String fallbacks;
.br
...
.br

.PP
INTERFACE(w,...)
.br
Widget w;
.br
...

.PP
CHILD(name,widget_class,...)
.br
String name;
.br
WidgetClass widget_class;
.br
...

.PP
GETCHILD(w)(name,widget_class,...)
.br
Widget w;
.br
String name;
.br
WidgetClass widget_class;
.br
...

.PP
END

.PP
ENDINTERFACE

.PP
CALLBACK(name,proc,calldata)
.br
String name;
.br
XtCallbackProc proc;
.br
XtPointer data;

.PP
EVENTHANDLER(eventmask,nonmaskable,proc,calldata)
.br
EventMask eventmask;
.br
Boolean nonmaskable;
.br
XtEventHandler proc;
.br
XtPointer calldata;

.PP
REALIZE

.SH DESCRIPTION

.I APPINITIALIZE
.br 
Child creation is defined at the \fIend\fP of the ressource list.
It performs a call to XtVaAppInitialize.

.PP
.I INTERFACE
.br
Set the toplevel widget.

.PP
.I CHILD
.br
Creates a child.

.PP
.I GETCHILD
.br
Such as CHILD, create a widget but allows you to get the \fIWidget
id\fP.

.PP
.I END
.br
Terminates the ressource list for widgets created with CHILD (or
GETCHILD).

.PP
.I ENDINTERFACE
.br
Terminates the ressource list for INTERFACE and APPINITIALIZE.

.PP
.I CALLBACK
.br
Add a callback to the callback list.

.PP
.I EVENTHANDLER
.br
Add an event handler.

.PP
.I REALIZE
.br
Performs a XtRealizeWidget of the toplevel.

.SH EXAMPLE

APPINITIALIZE(&app,"Workbench",NULL,0,   
.br                                       
		&argc,argv,                                                       
.br
		NULL,                                                             
.br	
		CHILD("row",xmRowColumnWidgetClass,                                     
.br
			CHILD("push",xmPushButtonWidgetClass,
.br
				 XmNwidth,100,         
.br
				CALLBACK(XmNactivateCallback,Callback,1),             
.br
			END),                                                 
.br
		END),                                                       
.br
		REALIZE,                                                          
.br
		ENDINTERFACE);

.SH AUTHOR

Olivier RAOUL
.br
E-mail: raoul_o@epita.fr

.SH BUGS

Motif is required for the exmaple.
.br

You can't do that:
.br
 Widget toplevel = APPINITIALIZE(...
.br
but:
.br
Widget toplevel;
toplevel = APPINITIALIZE(...
.br

Report them please. ;-)

.SH FILES

XtMacro.h 
.br
XtMacro.c
.br
libXtMacro.a
