// $Id: StatArray.h,v 1.1.2.1 1999/01/11 15:20:31 zeller Exp $ -*- C++ -*-
// Array of `stat' entries

// Copyright (C) 1999 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
// 
// This file is part of DDD.
// 
// DDD is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// DDD is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with DDD -- see the file COPYING.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers <ddd@ips.cs.tu-bs.de>.

#ifndef _DDD_StatArray_h
#define _DDD_StatArray_h

#ifdef __GNUG__
#pragma interface
#endif

#include "VarArray.h"
#include "DynArray.h"

#include "config.h"
#include "bool.h"

extern "C" {
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>

#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <fcntl.h>
}

inline bool operator==(const struct stat& sb1, const struct stat& sb2)
{
    return sb1.st_ino == sb2.st_ino && sb1.st_dev == sb2.st_dev;
}

typedef VarArray<struct stat> StatArray;

#endif // _DDD_StatArray_h
// DON'T ADD ANYTHING BEHIND THIS #endif
