#include <stdio.h>

#if defined(AIX)
#  include <sys/statfs.h>
#elif defined(SGI)
#  include <sys/statfs.h>
#  include <sys/types.h>
#elif defined(__alpha)
#  include <sys/types.h>
#  include <sys/mount.h>
#else
#  include <sys/statfs.h>
#  include <sys/types.h>
#endif

void getfsinfo( char *path);


void main( int nargs, char *argv[])
{
    while ( --nargs)
	getfsinfo( *++argv);
}

void getfsinfo( char *path)
{
    char           tmp[ 1024];
    struct statfs  sb;

#if defined(AIX)
    statfs( path, &sb);
#elif defined(SGI)
    statfs( path, &sb, sizeof(struct statfs), 0);
#else
    statfs( path, &sb, sizeof(struct statfs), 0);
#endif
    sprintf( tmp, "df %s", path);
    printf( "*****************************\n");
    printf( "df command :-\n");
    system( tmp);
    printf( "statfs call :-\n");
    printf( "Path = \"%s\"\n", path);
    printf( "Block size = %d\n", sb.f_bsize);
    printf( "Max Blocks = %d\n", sb.f_blocks);
    printf( "Free Blocks = %d\n", sb.f_bfree);
    printf( "Available Blocks = %d\n", sb.f_bavail);
    printf( "Fragment Size = %d\n", sb.f_frsize);
}
