/*****************************************************************************
 *
 *   olmotd.c   - Read & display a Message of the Day (and also a
 *		  file which is the past messages of the day).
 *		  With option to continue only if message has
 *		  has not been marked as read.
 *
 *   Written by:  Stuart Blackburn (sdblackb@uncc.edu)
 *		  Copyright (c) 1994 by Stuart Blackburn
 *
 *
 *  Portions
 *         From:
 *                   The X Window System,
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *	   
 *	   From:  Notices 
 *	   by	David Koontz (dak@uncc.edu)
 *		Copyright (c) 1992 by David Koontz
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include "olmotd.h"
int
main(argc, argv)
	int             argc;
	char           *argv[];
{
	AppDataType 	appdata;
	AppDataPtr	appdata_p;
	struct stat	statbuf;

	Widget          footerpanel, footer, rtile,
			controlarea, dismiss, acknowledge, history, help,
			textscroll,viewupperca,viewlowerca;
	void            dismiss_callback();
	void            acknowledge_callback();
	void            history_callback();
	void            help_callback();
	time_t          file_date();
	void            read_olmotd_file();
	void		update_motd();

	appdata_p = &appdata;
	
	appdata.display = NULL;
	appdata.xwin = NULL;
	appdata.app_cont = NULL;
	appdata.olmotd_icon = NULL;
	appdata.olmotd_iconmask = NULL;
	appdata.toplevel = NULL;
	appdata.footermsg = NULL;
	appdata.motdtext = NULL;
	appdata.showmotd = False;
	appdata.last_motd = 0;
	appdata.update = 0;
	appdata.directory = NULL;
	appdata.history_p = NULL;
	

	OlToolkitInitialize((XtPointer) NULL);
	appdata.toplevel = XtVaAppInitialize(&(appdata.app_cont), "Olmotd",
				   (XrmOptionDescList) options, 
				   XtNumber(options),
				   &argc, argv, NULL,
				   XtNtitle,	"Olmotd",
				   XtNiconic,	False,
				   NULL);

	appdata.directory = XtNewString(OLMOTD_DIR);
	read_olmotd_file(appdata_p);


	/*
	 *  Retrieve the resources.
	 */
	XtGetApplicationResources(appdata.toplevel, &appdata, resources, 
				    XtNumber(resources), NULL, 0);
	
	/* 
	 * allocate memory for path/filename to MOTD
	 */
	appdata.motd_p = (char *) XtCalloc(1, sizeof(char)*
	(strlen(appdata.directory) + 1 + strlen(MOTD_FILENAME) + 1) );
		
	strcpy(appdata.motd_p, appdata.directory);
	strcat(appdata.motd_p, "/");
	strcat(appdata.motd_p, MOTD_FILENAME);

	/* Get time stamp of the current MOTD file */
	appdata.current_motd = file_date(appdata.motd_p);
	
	/* Check for newonly option and MOTD file already read  */
	/* or if MOTD file does not exist. Exit if newonly an   */
	/* either of the other two are true.			*/
	if (appdata.newonly == TRUE) {
		/* If MOTD file doesn't exist exit */
		if (fopen(appdata.motd_p, "r") == NULL ) exit(0);

		/* If MOTD file has already been read exit */
		if (appdata.current_motd <= appdata.last_motd) exit(0);
			
		/* If MOTD file has zero size exit */
		stat(appdata.motd_p, &statbuf); 
		if (statbuf.st_size == 0) exit(0);			
	} 

	appdata.display = XtDisplay(appdata.toplevel);
	appdata.xwin = XtWindow(appdata.toplevel);

	footerpanel = XtVaCreateManagedWidget("footerpanel",
				footerPanelWidgetClass, appdata.toplevel,
				NULL);
	
	rtile = XtVaCreateManagedWidget("rtile",
					rubberTileWidgetClass, footerpanel,
					NULL);
					
	footer = XtVaCreateManagedWidget("footer",
				formWidgetClass, footerpanel,
				NULL);

	appdata.footermsg = XtVaCreateManagedWidget("leftfooter",
				captionWidgetClass, footer,
				XtNlabel,	"",
				XtNxOffset,	10,
				XtNyOffset,	4,
				NULL);
	/*
	 * Create the ControlArea and Buttons
	 */
	controlarea = XtVaCreateManagedWidget("controlarea",
					      controlAreaWidgetClass, rtile,
					      XtNweight, 0,
					      NULL);
	dismiss = XtVaCreateManagedWidget("dismiss",
					oblongButtonWidgetClass, controlarea,
					XtNlabel,	"Dismiss",
					NULL);
	acknowledge = XtVaCreateManagedWidget("acknowledge",
					oblongButtonWidgetClass, controlarea,
					XtNlabel, "Acknowledge",
					NULL);

	history = XtVaCreateManagedWidget("history",
					oblongButtonWidgetClass, controlarea,
					XtNlabel, "History",
					NULL);

	help = XtVaCreateManagedWidget("help",
					oblongButtonWidgetClass, controlarea,
					XtNlabel, "Help",
					XtNlabelType, OL_POPUP,
					NULL);
	/*
	 * Add OLIT Help for buttons
	 */
	OlRegisterHelp(OL_WIDGET_HELP, (char *) dismiss, "Dismiss",
			OL_STRING_SOURCE, (XtPointer)dismiss_help_msg);
	OlRegisterHelp(OL_WIDGET_HELP, (char *) acknowledge, "Acknowledge",
			OL_STRING_SOURCE, (XtPointer)acknowledge_help_msg);
	OlRegisterHelp(OL_WIDGET_HELP, (char *) history, "History/MOTD",
			OL_STRING_SOURCE, (XtPointer)history_help_msg);
	OlRegisterHelp(OL_WIDGET_HELP,(char *) help, "Help",
			OL_STRING_SOURCE,(XtPointer)help_help_msg);
	/*
	 * Add call backs for buttons
	 */
	XtAddCallback(dismiss, XtNselect, dismiss_callback, &appdata);
	XtAddCallback(acknowledge, XtNselect, acknowledge_callback, &appdata);
	XtAddCallback(history, XtNselect, history_callback, &appdata);
	XtAddCallback(help, XtNselect, help_callback, &appdata);
	
	
	/*
	 * Create the text area in main window
	 */
	textscroll = XtVaCreateManagedWidget("textscroll",
					scrolledWindowWidgetClass, rtile,
					XtNweight, 1,
					NULL);

	appdata.motdtext = XtVaCreateManagedWidget("motdtext",
			textEditWidgetClass,	textscroll,
			XtNsourceType,		OL_DISK_SOURCE,
			XtNeditType,		OL_TEXT_READ,
			XtNsource,		appdata.motd_p,
			XtNcharsVisible,	72,
			XtNlinesVisible,	24,
			NULL);

	/*
	 * Create help popup widgets
	 */
	appdata.help_popup = XtVaCreatePopupShell("help_popup",
				popupWindowShellWidgetClass, help,
				XtNtitle,	"Olmotd: Help",
				NULL);
	XtVaGetValues(appdata.help_popup,
			XtNupperControlArea,	&viewupperca,
			XtNlowerControlArea,	&viewlowerca,
			NULL);
	textscroll = XtVaCreateManagedWidget("textscroll",
			scrolledWindowWidgetClass, viewupperca,
			NULL);
	appdata.help_text = XtVaCreateManagedWidget("help_text",
			textEditWidgetClass,	textscroll,
			XtNsourceType,		OL_DISK_SOURCE,
			XtNeditType,		OL_TEXT_READ,
			XtNcharsVisible,	70,
			XtNlinesVisible,	40,
			XtNsource,		HELP_FILE,
			NULL);
	
	/*
	 * Register timeout to check for a new MOTD
	 */
	 
	XtAppAddTimeOut(appdata.app_cont, (appdata.update*60*1000), update_motd, appdata_p);

	XtRealizeWidget(appdata.toplevel);

	/*
	 * Now that the widgets are "realized"
	 * we need to set up the icon - for this
	 * we need the display & window struct
	 */
	appdata.display = XtDisplay(appdata.toplevel);
	appdata.xwin = XtWindow(appdata.toplevel);

	/*
	 * Create the pixmap for the icon
	 */
	appdata.olmotd_iconmask = XCreateBitmapFromData(appdata.display,
				appdata.xwin, olmotd_mask_bits,
				olmotd_mask_width,
				olmotd_mask_height);
	appdata.olmotd_icon = XCreateBitmapFromData(appdata.display,
				appdata.xwin, olmotd_bits,
				olmotd_width, olmotd_height);
	/*
	 * Assign an image for the icon
	 */
	XtVaSetValues(appdata.toplevel,
			XtNiconPixmap,		appdata.olmotd_icon,
			XtNiconMask,		appdata.olmotd_iconmask, 
			XtNiconName,		"OLMOTD",
			NULL);

	/*
	 * Start the X event loop
	 */
	XtAppMainLoop(appdata.app_cont);

	return(0);
}
