/*****************************************************************************
 *
 *   olmotd.h  - Header file for olmotd program
 *
 *   Written by:  Stuart Blackburn (sdblackb@uncc.edu)
 *		  (c) Copyright 1995 by Stuart Blackburn
 *
 ****************************************************************************/

static char version[] = "@(#)olmotd.h ver 1.4 8-17-95";
 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xol/OpenLook.h>

/* Specific Widget Headers */
#include <Xol/RubberTile.h>
#include <Xol/ControlAre.h>
#include <Xol/OblongButt.h>
#include <Xol/Caption.h>
#include <Xol/Form.h>
#include <Xol/FooterPane.h>
#include <Xol/TextEdit.h>
#include <Xol/PopupWindo.h>
#include <Xol/ScrolledWi.h>
#include <Xol/BaseWindow.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>

#include "olmotd.icon"
#include "olmotd_mask.icon"

  /**********************************************************************/
  /* Set these file and directory names appropriately for your system   */
  /*							 		*/
  /*	  OLMOTD_DIR -- The name of the directory where MOTD and HISTORY*/
  /*		        files will be located				*/
  /*	 OLMOTD_FILE -- The name of the user's timestamp file 		*/
  /*   MOTD_FILENAME -- The name given to the Message of the Day file	*/
  /*		        inside the OLMOTD_DIR				*/
  /* HISTORY_FILENAME-- The name given to the MOTD history file,	*/
  /*		        if it exists					*/
  /*       HELP_FILE -- The path to the help file that I provided.	*/
  /*		      Setting the entire path here is meant to allow it */
  /*		      to be located away from the other files		*/
  /**********************************************************************/
#ifdef DEBUG
#define OLMOTD_DIR "."
#else
  /* Set this to point to the directory in which the MOTD_FILENAME will be */ 
#define OLMOTD_DIR "/afs/uncc.edu/coe/public/MOTD"
#endif

#define OLMOTD_FILE 		".olmotdrc"
#define MOTD_FILENAME		"MOTD"
#define HISTORY_FILENAME 	"MOTD.history"
#define HELP_FILE               "/afs/uncc.edu/coe/apps/olmotd/help.txt"

/*
 * Set this according to your flavor of UNIX 
 * (This is the particular stat structure member which tells the
 * time of last status change of the file.)
 * Have only one of the defines uncommented.
 */

/* For SYSV UNIX like Solaris 2.X use this */
#define TIME_STRUCT  st_ctim.tv_sec

/* For SunOS4.1.3 (and perhaps others) use the #define below instead */
/* #define TIME_STRUCT st_ctime */

/* I am not don't have access to any other OSs. If you alter this to */
/* fit your OS, and would like to share the info with me please just */
/* send me some e-mail, and I will update the distribution	     */

/*
 * Define help messages
 */

static String dismiss_help_msg = { 
"Dismiss\n\n\
The Dismiss button closes the olmotd application to an icon, and DOESN'T \
mark that the message was read." 
};

static String acknowledge_help_msg = { 
"Acknowledge\n\n\
This button marks the .olmotdrc file so that you will not see olmotd \
again until there is a NEW message of the day. If this button is never \
pressed, olmotd will open everytime you login showing the latest Message \
of the Day."
 };
static String history_help_msg = { 
"History or MOTD\n\n\
This button will toggle the MOTD (Message Of The Day) and a MOTD history \
file. The Message Of The Day file contains important information that all \
users need to know. Displaying the MOTD file is the main purpose of Olmotd \
This MOTD history file contains a listing of previous MOTD's and the dates \
which they were first entered." 
};

static String help_help_msg = { 
"Help\n\n\
This button pops up a window with information about olmotd, and how to use it." 
};

typedef struct {
	Display	       *display;
	Window		xwin;
	XtAppContext	app_cont;
	Pixmap		olmotd_icon;
	Pixmap		olmotd_iconmask;
	Widget		toplevel;
	Widget          footermsg;	/* left footer message */
	Widget		motdtext;
	Widget		help_popup;	/* For help popup window */
	Widget		help_text;	/* Text widget for help popup */
	time_t		current_motd;	/* time stamp of current MOTD */
	time_t		last_motd;	/* time stamp of last read of MOTD */
	String		directory;	/* olmotd file dir */
	String		motd_p;		/* holds the path to the motd file */
	String		history_p;	/* holds the path to the history file */
	int		update;		/* # of min. delay to check for new MOTD */
	Boolean		newonly;	/* T/F flag to run only if MOTD is new*/
	Boolean		showmotd;	/* T/F flag for which file is being displayed currently */
}               AppDataType, *AppDataPtr;


/*
 * Define new resources for application
 */
static XtResource resources[] = {
  { "update", "Update", XtRInt, sizeof (int),
    XtOffset(AppDataPtr, update), XtRString,"30" },
  { "newonly", "Newonly", XtRBoolean, sizeof (Boolean),
    XtOffset(AppDataPtr, newonly), XtRString, "FALSE"},
  };

/*
 * Define command line options to pull off the argv string
 * & set the resource
 */
static XrmOptionDescRec options[] = { 
  {"-update",   "*update",	XrmoptionSepArg, (caddr_t) NULL},
  {"-newonly",	"*newonly",	XrmoptionNoArg,	(XtPointer)"TRUE"}
};

/*
 * Define fall back resources for application
 */
static String fallback_resources[] = {
 "*background:gray\n\
  *text.background:white\n\
  *text.inputFocusColor:black\n\
  *geometry:+0+0\n\
  *font:*-fixed-medium-r-*-*-18-*-*-\n\
  *update:30\n\
  *newonly:FALSE"
};
