.\" Written by Stuart Blackburn UNC-Charlotte 8/94
.\"
.TH OLMOTD 1 "17 August 1995"  " "
.SH NAME
olmotd \- OpenLook message of the day viewer.

Version 1.4 - Aug 1995 - Copyright 1995 Stuart Blackburn
.SH SYNOPSIS
.B olmotd
[
.B \-newonly
]
[
.B \-update time-in-minutes
]
.SH DESCRIPTION
.LP
olmotd is a mechanism for system administrators to displaying important
messages to their users. It is set up so that if you use the -newonly
option, the program will only open up if there is a new message. You
can of course run it with no options, and get the message regardless
of whether or not you have seen it before.
To mark that you have seen the MOTD (Message Of The Day), you must
press the acknowledge button. Because of this, the user must take
responsibility for reading this message and acting accordingly. Only
acknowledge button timestamps the file in the user's account (the
default is .olmotdrc). So until you acknowledge the MOTD, it will come
up at every login. (Here at UNCC, we make sure that olmotd -newonly is
run at everyone's login.)
.SH OPTIONS
.TP 
.B \-newonly
This option causes Olmotd to open only if you have not acknowledged the
current Message of the Day, if the Message of the Day file doesn't exist,
or if the Message of the Day file has zero length. This is the usual 
method of starting Olmotd.

.B \-update
This option specifies the time (in minutes) that Olmotd should wait before
checking for a new Message of the Day

.SH FILES
.LP
.B /afs/uncc.edu/coe/public/MOTD		motd directory
.br
.B <motd dir>/MOTD				MOTD file
.br
.B <motd dir>/MOTD.history			History file
.br
.B $HOME/.olmotdrc				user's olmotd file
.br
.B /afs/uncc.edu/coe/unix/sunos5/app-defaults/Olmotd	app defaults file
.SH RESOURCES
.LP
.B Olmotd*geometry:			+0+0 (top left corner)
.br
.B Olmotd*background:			gray
.br
.B Olmotd*inputFocusColor:		gray75
.br
.B Olmotd*text.background:		white
.br
.B Olmotd*text.inputFocusColor:	black
.br
.B Olmotd*newonly:			FALSE
.br
.B Olmotd*update:				30
.br
.B Olmotd*font:				*-fixed-medium-r-*-*-18-*-*-
.SH KNOWN BUGS
If Olmotd is open during the update, and it discovers that the MOTD
has been modified since the last update it closes itself instead
of remaining open.

.SH SEND BUGS/REQUESTS TO: 
.br 
Stuart Blackburn (sdblackb@mosaic.uncc.edu)
