/*****************************************************************************
 *
 *   procs.c  - C procdures and button callbacks for olmotd.c program
 *
 *   Written by:  Stuart Blackburn (sdblackb@uncc.edu)
 *		  Copyright (c) 1994 by Stuart Blackburn
 *
 ****************************************************************************/
#include "olmotd.h"


time_t file_date(filename)
String		filename;
{
	struct stat	statbuf;
		
	stat(filename, &statbuf);
		
	/* TIME_STRUCT should be properly defined in olmotd.h */
	/* to match your version of UNIX */
	return(statbuf.TIME_STRUCT);  
	
}

void
dismiss_callback(w, client_data, call_data)
	Widget          w;
	XtPointer       client_data, call_data;
{
	AppDataPtr      appdata = (AppDataPtr) client_data;

	/*
	 * Set XtNiconic to false so it can be iconified
	 */
	XtVaSetValues(appdata->toplevel,
			XtNiconic,	FALSE,
			NULL);
	/*
	 * Iconify olmotd 
	 */
	XtVaSetValues(appdata->toplevel,
			XtNiconic,	TRUE,
			NULL);

}
void
acknowledge_callback(w, client_data, call_data)
	Widget          w;
	XtPointer       client_data, call_data;
{
	AppDataPtr      appdata = (AppDataPtr) client_data;
	FILE           *ref_fp;
	String          homep, pathp;

	/*
	 * Make sure that user is acknowledging the MOTD file not HISTORY file
	 */
	if (appdata->showmotd == True) {
		XtVaSetValues(appdata->footermsg,
			XtNlabel,	"You can only acknowledge the MOTD",
			NULL);
		return;
	}
	
	/*
	 * See if the users olmotd_file exists and get the time stamp
	 */
	homep = getenv("HOME");
	pathp = (char *) XtCalloc(1, sizeof(char) * (strlen(homep) + 1 + strlen(OLMOTD_FILE) + 1));
	strcpy(pathp, homep);
	strcat(pathp, "/");
	strcat(pathp, OLMOTD_FILE);

	/* Open the file for writing */
	/* (w+ to ignore old file, and write at the beginning of file) */
	ref_fp = fopen(pathp, "w+"); 

	if (ref_fp == NULL) { 
		/* OLMOTD_FILE does not exist and can't be created */
		fprintf(stderr, "Error opening %s.\nOlmotd could not mark that you read the MOTD.\nCheck your quota, or ask a TA for further assistance.\n", pathp);
		return;
	}else {
	/*
	 * set timestamp in OLMOTD_FILE equal to time of current
	 * MOTD file since they are acknowledging reading the file,
	 * and set appdata->last_motd similarily.
	 */	
	appdata->last_motd = file_date(appdata->motd_p);
	fprintf(ref_fp, "%ld\n", appdata->last_motd);
	fclose(ref_fp);
	/*
	 * Put a message in the footer
	 */
	XtVaSetValues(appdata->footermsg,
			XtNlabel, "It has been marked that you read this MOTD",
			NULL);
	}

}
void
history_callback(w, client_data, call_data)
	Widget          w;
	XtPointer       client_data, call_data;
{
	AppDataPtr      appdata = (AppDataPtr) client_data;
        /* 
         * IF MOTD showing switch to history file
         */
         
 	if ( appdata->showmotd == False )  {
 		if (appdata->history_p == NULL) {
 		    /* 
		     * allocate memory for path/filename to HISTORY
		     */
		    appdata->history_p = (char *) XtCalloc(1, sizeof(char)*
		    (strlen(appdata->directory)+1+strlen(HISTORY_FILENAME)+ 1));		
		    strcpy(appdata->history_p, appdata->directory);
		    strcat(appdata->history_p, "/");
		    strcat(appdata->history_p, HISTORY_FILENAME);
		}
	       /*
	        * Set textedit widget source to HISTORY_FILENAME
	        */
		if (fopen(appdata->history_p, "r") != NULL ) {
			XtVaSetValues(appdata->motdtext,
				XtNsource,	appdata->history_p,
				NULL);
	       		/*
	       		 * Set button label to MOTD to indicate it will 
	        	 * load motd if pressed now.
	        	 */
			XtVaSetValues(w,
				XtNlabel,	"MOTD",
				NULL);
			appdata->showmotd = True;
			XtVaSetValues(appdata->footermsg,
				XtNlabel,	"Displaying the History file",
				NULL);
		} else
			XtVaSetValues(appdata->footermsg,
				XtNlabel,  "No History file is provided.",
				NULL);
		
	} else {
	       /*
	        * Set textedit widget source to MOTD_FILENAME
	        */
		XtVaSetValues(appdata->motdtext,
			XtNsource,	appdata->motd_p,
			NULL);
	       /*
	        * Set button label to History to indicate it will load history
	        * if pressed now.
	        */
		XtVaSetValues(w,
			XtNlabel,	"History",
			NULL);
		XtVaSetValues(appdata->footermsg,
			XtNlabel,	"Displaying the Message of the Day",
			NULL);
		appdata->showmotd = False;
	}

}

void
help_callback(w, client_data, call_data)
	Widget          w;
	XtPointer       client_data, call_data;
{
	AppDataPtr      appdata = (AppDataPtr) client_data;
	/*
	 * Put a message in the footer
	 */
	XtVaSetValues(appdata->footermsg,
			XtNlabel,	"Opening Help window",
			NULL);

	XtPopup(appdata->help_popup, XtGrabNone);	
}

void 
read_olmotd_file(appdata)
	AppDataPtr      appdata;
{
	FILE           *ref_fp;
	String          homep, pathp;
	/*
	 * See if the users olmotd_file exists and get the time stamp
	 */
	homep = getenv("HOME");
	pathp = (char *) XtCalloc(1, sizeof(char) * (strlen(homep) + 1 + strlen(OLMOTD_FILE) + 1));
	strcpy(pathp, homep);
	strcat(pathp, "/");
	strcat(pathp, OLMOTD_FILE);
	ref_fp = fopen(pathp, "r");
	if (ref_fp == NULL) {
		/*
		 * OLMOTD_FILE does not exist create it
		 */
		ref_fp = fopen(pathp, "w");
		/* if file can't be opened, then give error but open MOTD
		 * anyway.
		 */
		if (ref_fp == NULL) {
			fprintf(stderr, "Error opening %s.\nCheck your quota, or ask a TA for quota assistance.\n", pathp);
			appdata->last_motd = 0;
		}
		/*
		 * set timestamp in OLMOTD_FILE to zero since their
		 * file didn't exist and set appdata->last_motd
		 * to zero for similar reasons.
		 */
		 else {
		 	appdata->last_motd = 0;
		 	fprintf(ref_fp, "%ld\n", appdata->last_motd);
		 }
	} else {
		if( fscanf(ref_fp, " %ld", &appdata->last_motd) == EOF)
			fprintf( stderr, "ERROR in reading %s", pathp);
	}

	XtFree(pathp);		/* free memory */
	fclose(ref_fp);
}

void
update_motd(client_data, id)
	XtPointer       client_data;
	XtIntervalId   *id;
{
	AppDataPtr      appdata = (AppDataPtr) client_data;
	time_t		tmp_time;

#ifdef DEBUG	
	static int update_num = 0;
	printf("\tupdate # %i\n",update_num);
	update_num++;
#endif
	
	/*
	 * Check to see if MOTD modification time is greater than
	 * it was when last checked. 
	 */
	tmp_time = file_date(appdata->motd_p);
	if (tmp_time > appdata->current_motd) {

		/* Update the time of the current MOTD */
		appdata->current_motd = tmp_time;
		
	       /*
	        * Reset textedit widget source to MOTD_FILENAME
	        */
		XtVaSetValues(appdata->motdtext,
			XtNsource,	appdata->motd_p,
			NULL);
	       /*
	        * Set button label to History to indicate it will load history
	        * if pressed now.
	        */
		XtVaSetValues(appdata->footermsg,
			XtNlabel,	"Displaying NEW Message of the Day",
			NULL);
		appdata->showmotd = False;		
		/*
		 * Set XtNiconic to true so it can be opened
		 * (I really don't know why this must be done ?? )
		 */
		XtVaSetValues(appdata->toplevel,
			XtNiconic,	TRUE,
			NULL);
		/*
		 * Open olmotd 
		 */
		XtVaSetValues(appdata->toplevel,
			XtNiconic,	FALSE,
			NULL);
	}
	/*
	 * Intrinsics removes the timeouts when they occur,
	 * so re-register the timeout
	 */
	 XtAppAddTimeOut(appdata->app_cont, appdata->update*60*1000, update_motd, appdata);

}
