/*
 * http://www.mit.edu:8001/afs/athena.mit.edu/course/other/cdsdev/html/Faq/comp.windows.x/q.136
 * Subject: 136)  Why can't my program work with tvtwm or swm?

 *	A number of applications, including xwd, xwininfo, and xsetroot, do not
 * handle the virtual root window which tvtwm and swm use; they typically return 
 * the wrong child of root. A general solution is to add this code or to use it in
 * your own application where you would normally use RootWindow(dpy,screen):
 */

/* Function Name: GetVRoot
 * Description: Gets the root window, even if it's a virtual root
 * Arguments: the display and the screen
 * Returns: the root window for the client
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
Window GetVRoot(dpy, scr)
Display        *dpy;
int             scr;
{
Window          rootReturn, parentReturn, *children;
unsigned int    numChildren;
Window          root = RootWindow(dpy, scr);
Atom            __SWM_VROOT = None;
int             i;

  __SWM_VROOT = XInternAtom(dpy, "__SWM_VROOT", False);
  XQueryTree(dpy, root, &rootReturn, &parentReturn, &children, &numChildren);
  for (i = 0; i < numChildren; i++) {
	Atom            actual_type;
	int             actual_format;
	/* long            nitems, bytesafter;
         */
	unsigned long            nitems, bytesafter;  /* modified by tian */
	Window         *newRoot = NULL;

	if (XGetWindowProperty(dpy, children[i], __SWM_VROOT, 0, 1,
	    False, XA_WINDOW, &actual_type, &actual_format, &nitems,
            &bytesafter, (unsigned char **) &newRoot) == Success && newRoot) {
			root = *newRoot;
			break;
	}
   }

   return root;
}

/*
 *[courtesy David Elliott (dce@smsc.sony.com). Similar code is in ssetroot, a
 *version of xsetroot distributed with tvtwm. 2/91]
 *
 *A header file by Andreas Stolcke of ICSI on export.lcs.mit.edu:contrib/vroot.h 
 *functions similarly by providing macros for RootWindow and DefaultRootWindow;
 *code can include this header file first to run properly in the presence of a
 *virtual desktop.
 *	
 *----------------------------------------------------------------------
 */
