#include <stdio.h>
#include <ctype.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

/* this is for tvtwm and swm, because they make use of virtual root window */ 
extern Window GetVRoot(Display*, int);  

static char *Nil = "(nil)";

static void lookat( Display*, int, Window, Bool, int);
static void print_client_properties( Display*, int, Window, Window, Bool, int);
static int print_quoted_word ( char*, int);
static void print_text_field (Display*, char*, XTextProperty*);
static void unknown(Display*, Atom, int);

static void usage(char *prog_name)
{
   fprintf(stderr, 
           "usage: %s [-v] [-d[isplay] display_name]\n",
            strrchr(prog_name,'/')==NULL? prog_name : strrchr(prog_name,'/')+1);
   fprintf(stderr, "      -v                          verbose.\n");
   fprintf(stderr, "      -d       display_name       \n");
   fprintf(stderr, "   or -display display_name       specify display.\n");
   exit(1);
}

int main (argc, argv)
    int argc;
    char **argv;
{
    int i;
    char *displayname = NULL;
    Bool verbose = False;
    Display *dpy;
    int maxcmdlen = 10000;
  
    if(argc == 999 ) {
        /* this message is for strings(1). */
        printf("Here!!!.\n");
        printf("the source is in tian's pub/src. tian@aluxpo.micro.lucent.com, x7668. \n");
    }

    for(i=0; i<argc; i++) {
        char *arg = argv[i];
        if(arg[0] == '-') {
              switch (arg[1]) {
                 case 'v': verbose =True;
                           continue; 
                 case 'd': if(++i >= argc) usage(argv[0]);
                           displayname = argv[i];
                           continue;
                 default : usage(argv[0]);
              }
        }
    }

    if( (dpy=XOpenDisplay (displayname)) == NULL ) {
	fprintf( stderr, 
                 "%s: unable to open display %s \n", 
                 argv[0], XDisplayName (displayname) );
	exit (1);
    }
    

    /* try to open all screens */
    for (i = 0; i < ScreenCount(dpy); i++)  {
         /* 
          * if only for olvwm(1), we can use the following
          *     lookat (dpy, i, RootWindow(dpy,i), verbose, maxcmdlen);
          * but tvtwm(1) and swm(1) use a virtual root window.
          */
          lookat (dpy, i, GetVRoot(dpy,i), verbose, maxcmdlen);
    }

    XCloseDisplay (dpy);

    exit(0);
}

static void lookat (dpy, screen_number, root, verbose, maxcmdlen)
    Display *dpy;
    int screen_number;
    Window root;
    Bool verbose;
    int maxcmdlen;
{
    Window dummy, *children = NULL, client;
    unsigned int i, nchildren = 0;

    /*
     * clients are not allowed to stomp on the root and ICCCM doesn't yet
     * say anything about window managers putting stuff there; but, try
     * anyway.
     */

    XBell(dpy, 100);

    XSync(dpy, False);

    /* because it will take a while, let's grep the input to avoid messing up. */ 
    if (XGrabKeyboard (dpy, root, False, GrabModeAsync, GrabModeAsync, CurrentTime)
        != GrabSuccess) {
             XBell(dpy, 100);
             fprintf(stderr, "warning: cannot grab the keyboard. \n");
    }
    if (XGrabPointer (dpy, root,
                      False, 0, GrabModeAsync, GrabModeAsync, None, 
                      XCreateFontCursor(dpy, XC_watch), 
                      CurrentTime)                           
       != GrabSuccess) {
             XBell(dpy, 100);
             fprintf(stderr, "warning: cannot grab the pointer. \n");
    }
    print_client_properties (dpy, screen_number, root, root, verbose, maxcmdlen);

    /* then, get the list of windows */
    if (!XQueryTree (dpy, root, &dummy, &dummy, &children, &nchildren)) return;

    for (i = 0; i < nchildren; i++) {
	client = XmuClientWindow (dpy, children[i]);
	if (client != None)
	  print_client_properties (dpy, screen_number, root, client, verbose, maxcmdlen);
    }

    XUngrabKeyboard(dpy, CurrentTime);
    XUngrabPointer(dpy,  CurrentTime);

    XBell(dpy, 100);

}

/* the arguement 'root' is designed for tvtwm(1) and swm(1) which use a virtual root */
static void print_client_properties (dpy, screen_number, root, w, verbose, maxcmdlen)
    Display *dpy;
    int screen_number;
    Window root, w;     
    Bool verbose;
    int maxcmdlen;
{
    char **cliargv = NULL;
    int i, cliargc;
    XTextProperty nametp, machtp;
    int charsleft = maxcmdlen;
    Status status;
    long longjunk;
    XSizeHints hints;
    XWindowAttributes win_attributes;
    int dw = DisplayWidth (dpy, screen_number), dh = DisplayHeight (dpy, screen_number);
    int rx, ry, xright, ybelow;
    int showright = 0, showbelow = 0;
    Window wmframe;
    Window junkwin;

    if (!XGetWindowAttributes(dpy, w, &win_attributes)) {
         fprintf(stderr, "Can't get window attributes.");
         exit(1);
    }

    (void) XTranslateCoordinates (dpy, w, win_attributes.root, 
                                  -win_attributes.border_width,
                                  -win_attributes.border_width,
                                  &rx, &ry, &junkwin);
                                
    xright = (dw - rx - win_attributes.border_width * 2 -
              win_attributes.width);
    ybelow = (dh - ry - win_attributes.border_width * 2 -
              win_attributes.height);

    /* get the WM_MACHINE and WM_COMMAND list of strings */
    if (!XGetWMClientMachine (dpy, w, &machtp)) {
        machtp.value = NULL;
        machtp.encoding = None;
    }

    if (!XGetCommand (dpy, w, &cliargv, &cliargc)) {
	if (machtp.value) XFree ((char *) machtp.value);
	return;
    }

    /* do header information */
    if (verbose) {
	printf ("Window 0x%lx:\n", w);
	print_text_field (dpy, "  Machine:  ", &machtp);
	if (XGetWMName (dpy, w, &nametp)) {
	    print_text_field (dpy, "  Name:  ", &nametp);
	    if (nametp.value) XFree ((char *) nametp.value);
	}
        if (machtp.value) XFree ((char *) machtp.value);

        /* do the command */
	printf ("  Command:  ");
    }

    /* the lauching command */
    if(verbose) printf ("%s ", cliargv[0] );
    else  { 
        /* strip off the heading dir */
        char *cmd=strrchr(cliargv[0], '/');
        printf("%s ", cmd? cmd+1 : cliargv[0] );
    }
    
    /* now update geometry state */
    printf(" -geometry ");

    /* compute size in appropriate units */
    status = XGetWMNormalHints(dpy, w, &hints, &longjunk);
    if (status  &&  hints.flags & PResizeInc  &&
                hints.width_inc != 0  &&  hints.height_inc != 0) {
        if (hints.flags & (PBaseSize|PMinSize)) {
            if (hints.flags & PBaseSize) {
                win_attributes.width -= hints.base_width;
                win_attributes.height -= hints.base_height;
            } else {
                /* ICCCM says MinSize is default for BaseSize */
                win_attributes.width -= hints.min_width;
                win_attributes.height -= hints.min_height;
            }
        }
        printf("%dx%d", win_attributes.width/hints.width_inc,
               win_attributes.height/hints.height_inc);
    } else
        printf("%dx%d", win_attributes.width, win_attributes.height);
  
    if (!(hints.flags&PWinGravity))
        hints.win_gravity = NorthWestGravity; /* per ICCCM */
    /* find our window manager frame, if any */
    wmframe = w;
    while (True) {
        Window junkroot, parent;
        Window *childlist;
        unsigned int ujunk;
  
        status = XQueryTree(dpy, wmframe, &junkroot, &parent, &childlist, &ujunk);
        /* if only for olvwm(1), we can use the following
         *      if (parent == junkroot || !parent || !status)
         * because junkroot is the real root window. however, tvtwm(1) and swm(1)
         * use a virtual root window.
         */
        if (parent == root || !parent || !status)
            break;
        wmframe = parent;
        if (status && childlist)
            XFree((char *)childlist);
    }
    if (wmframe != w) {
        /* WM reparented, so find edges of the frame */
        /* Only works for ICCCM-compliant WMs, and then only if the
           window has corner gravity.  We would need to know the original width
           of the window to correctly handle the other gravities. */
  
        XWindowAttributes frame_attr;
  
        if (!XGetWindowAttributes(dpy, wmframe, &frame_attr)) {
            fprintf(stderr, "Can't get frame attributes.\n");
            exit(1);
        }
        switch (hints.win_gravity) {
          case NorthWestGravity: case SouthWestGravity:
          case NorthEastGravity: case SouthEastGravity:
          case WestGravity:
            rx = frame_attr.x;
        }
        switch (hints.win_gravity) {
          case NorthWestGravity: case SouthWestGravity:
          case NorthEastGravity: case SouthEastGravity:
          case EastGravity:
            xright = dw - frame_attr.x - frame_attr.width -
                2*frame_attr.border_width;
        }
        switch (hints.win_gravity) {
          case NorthWestGravity: case SouthWestGravity:
          case NorthEastGravity: case SouthEastGravity:
          case NorthGravity:
            ry = frame_attr.y;
        }
        switch (hints.win_gravity) {
          case NorthWestGravity: case SouthWestGravity:
          case NorthEastGravity: case SouthEastGravity:
          case SouthGravity:
            ybelow = dh - frame_attr.y - frame_attr.height -
                2*frame_attr.border_width;
        }
    }
    /* If edge gravity, offer a corner on that edge (because the application
       programmer cares about that edge), otherwise offer upper left unless
       some other corner is close to an edge of the screen.
       (For corner gravity, assume gravity was set by XWMGeometry.
       For CenterGravity, it doesn't matter.) */
    if (hints.win_gravity == EastGravity  ||
        (abs(xright) <= 100  &&  abs(xright) < abs(rx)
          &&  hints.win_gravity != WestGravity))
        showright = 1;
    if (hints.win_gravity == SouthGravity  ||
        (abs(ybelow) <= 100  &&  abs(ybelow) < abs(ry)
          &&  hints.win_gravity != NorthGravity))
        showbelow = 1;
    
    if (showright)
        printf("-%d", xright);
    else
        printf("+%d", rx);
    if (showbelow)
        printf("-%d", ybelow);
    else
        printf("+%d", ry);
 
    printf(" ");
    /* end of geometry */

    /* now add the other arguements from the original cmdline. */
    for (i = 1; i < cliargc && charsleft > 0; ) {
        if( strcmp(cliargv[i], "-g") >= 0 ) {
            if( ! ( strcmp(cliargv[i], "-g") && 
                    strcmp(cliargv[i], "-ge") &&
                    strcmp(cliargv[i], "-geo") &&
                    strcmp(cliargv[i], "-geom") &&
                    strcmp(cliargv[i], "-geome") &&
                    strcmp(cliargv[i], "-geomet") &&
                    strcmp(cliargv[i], "-geometr") &&
                    strcmp(cliargv[i], "-geometry") ) )  {
                  /* 
                   * the original geometry havs been changed, so we ignore it with
                   * its arguemnet.
                   */
                  i += 2;
                  continue;
            }
        } 
	charsleft -= print_quoted_word (cliargv[i], charsleft);
	i++;
	if (i < cliargc  &&  charsleft > 0) {
	    putchar (' '); charsleft--;
	}
    }
    
 
    /* put it into background and end this line */
    putchar (' ');
    putchar ('&');
    putchar ('\n');
    XFreeStringList (cliargv);

    /* do trailer information */
    if (verbose) {
	XClassHint clh;
	if (XGetClassHint (dpy, w, &clh)) {
	    printf ("  Instance/Class:  %s/%s",
		    clh.res_name ? clh.res_name : Nil,
		    clh.res_class ? clh.res_class : Nil);
	    if (clh.res_name) XFree (clh.res_name);
	    if (clh.res_class) XFree (clh.res_class);
	    putchar ('\n');
	}
    }
}


static void print_text_field (dpy, s, tp)
    Display *dpy;
    char *s;
    XTextProperty *tp;
{
    if (tp->encoding == None || tp->format == 0) {
	printf ("''");
	return;
    }

    if (s) printf ("%s", s);
    if (tp->encoding == XA_STRING && tp->format == 8) {
	printf ("%s", tp->value ? (char *) tp->value : Nil);
    } else {
	unknown (dpy, tp->encoding, tp->format);
    }
    if (s) putchar ('\n');
}

/* returns the number of characters printed */
int
print_quoted_word (s, maxlen)
    char *s;
    int maxlen;			/* max number of chars we can print */
{
    register char *cp;
    Bool need_quote = False, in_quote = False;
    char quote_char = '\'', other_quote = '"';
    int charsprinted = 0;

    /*
     * walk down seeing whether or not we need to quote
     */
    for (cp = s; *cp; cp++) {

	if (! ((isascii(*cp) && isalnum(*cp)) || 
	       (*cp == '-' || *cp == '_' || *cp == '.' || *cp == '+' ||
		*cp == '/' || *cp == '=' || *cp == ':' || *cp == ','))) {
	    need_quote = True;
	    break;
	}
    }

    /*
     * write out the string: if we hit a quote, then close any previous quote,
     * emit the other quote, swap quotes and continue on.
     */
    in_quote = need_quote;
    if (need_quote) {
	putchar (quote_char);
	charsprinted++; maxlen--;
    }
    for (cp = s; *cp && maxlen>0; cp++) {
	if (*cp == quote_char) {
	    if (in_quote) {
		putchar (quote_char);
		charsprinted++; maxlen--;
	    }
	    putchar (other_quote);
	    charsprinted++; maxlen--;
	    { 
		char tmp = other_quote; 
		other_quote = quote_char; quote_char = tmp;
	    }
	    in_quote = True;
	}
	putchar (*cp);
	charsprinted++; maxlen--;
    }
    /* close the quote if we opened one and if we printed the whole string */
    if (in_quote && maxlen>0) {
	putchar (quote_char);
	charsprinted++; maxlen--;
    }

    return charsprinted;
}

void unknown(dpy, actual_type, actual_format)
    Display *dpy;
    Atom actual_type;
    int actual_format;
{
    char *s;

    printf ("<unknown type ");
    if (actual_type == None) printf ("None");
    else if ((s = XGetAtomName (dpy, actual_type)) != NULL) {
	fputs (s, stdout);
	XFree (s);
    } else {
	fputs (Nil, stdout);
    }
    printf (" (%ld) or format %d>", actual_type, actual_format);
}

