/* routines associated with displaying simple
 * information and sending mail to the author. A lot of this
 * is loosely based on code from Ftptool.
 */

#define RESOURCE_FILE	".robotxrc"


#ifndef MAILER
#define MAILER "mail"
#endif


#define	THE_WIDTH	560
#define PANEL_HEIGHT	25

#include <stdio.h>
#include <sys/utsname.h>
#include <malloc.h>

#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/cursor.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include <xview/textsw.h>
#include <xview/server.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/xv_error.h>

#include "robot.h"
#include "patchlevel.h"

Frame	frame;
Frame	register_frame;
Textsw	register_text;

char	sys_buff[240];
static char caret[2] ="\012"; /* without "static" got funnies with get_text */


void
write_stuff()
{
	totext2_("If you have problems with this program please contact:");
	sprintf(sys_buff, "%s", MY_ADDRESS);
	totext2_(sys_buff);
	totext2_("If you publish a paper which includes robot graphs please consider a reference");
	totext2_("(details under the \"About\" button).");

	totext2_(" ");
	totext2_("If your display is small, it may be useful to invoke robot");
	totext2_("With something like:");
	totext2_("robot -plotscale 0.5 -scale small\n\
(For non-OpenLook systems \"-notol\" is suggested)");
	top_text();

}


void
add_text(string)
char	*string;
{
	textsw_insert(register_text, string, strlen(string));
	textsw_insert(register_text, caret, 1);
}

/* just add a blank line */
void
add_blank()
{
	textsw_insert(register_text, caret, 1);
}

void
register_me()
{
        system(sys_buff);
        totext2_("Thank you!");
	xv_set(register_frame, XV_SHOW, FALSE, NULL);
	xv_set(register_frame, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
	write_stuff();

}

void
dont_register_me()
{
	xv_set(register_frame, XV_SHOW, FALSE, NULL);
	xv_set(register_frame, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
	write_stuff();
}


void
register_()
{
char	fname[140];
FILE	*fp;
struct utsname *name;

/* See if a .robotrxc file exists */

	name = (struct utsname *) calloc(1, sizeof(struct utsname));

	if(getenv("HOME") != NULL){
		sprintf(fname, "%s", (char *) getenv("HOME"));
	}
	else{
		return; /* give up if environment variable not set */
	}

	strcat(fname, "/");
	strcat(fname, RESOURCE_FILE);


	if ((fp = fopen(fname, "r")) != (FILE *) NULL) {
		/* file exists! */
		fclose(fp);
		return;
	}


	if ((fp = fopen(fname, "w")) == (FILE *) NULL) {
		/* printf("Couldn't open for write, quit\n"); */
		fclose(fp);
		return;
	}
			
/* To make sure we're a good citizen we'll only consider deleting
 * a file if we think we wrote it */

	if (fprintf(fp,"# Robot resource file\n") == EOF){
		fclose(fp);
		return; /* Quit if we can't write */
	}

	uname(name);	/* get system information */
/*	printf("%s\n", name->sysname);
	printf("%s\n", name->nodename);
	printf("%s\n", name->release);
	printf("%s\n", name->version);
	printf("%s\n", name->machine); */

	fprintf(fp,"# Currently used only to identify itself\n");
	fprintf(fp,"#program=robotx\n");
	fprintf(fp,"#author=rcorbet\n");
	fprintf(fp, "#version=%-1.2f\n", VERSION);
	fprintf(fp, "#patch=%d\n", PATCHLEVEL);
	if(getenv("USER") != NULL)
		fprintf(fp, "#user=%s\n", (char *) getenv("USER"));
	if(getenv("HOST") != NULL)
		fprintf(fp, "#host=%s\n", (char *) getenv("HOST"));
	fprintf(fp, "#machine=%s\n", name->machine);
	fprintf(fp, "#OS=%s\n", name->sysname);
	fprintf(fp, "#OSrelease=%s\n",name->release);

	fclose(fp);

	get_frame(&frame);

/* make the frame */
	register_frame = xv_create(frame, FRAME_CMD,
				FRAME_LABEL, "Register Robot?",
				FRAME_SHOW_FOOTER,	FALSE,
				FRAME_CMD_PUSHPIN_IN, TRUE,
				NULL);
	register_panel = xv_get(register_frame, FRAME_CMD_PANEL);
	xv_set(register_panel, 
		XV_WIDTH, THE_WIDTH,
		XV_HEIGHT, PANEL_HEIGHT,
		XV_X,	0,
		PANEL_LAYOUT, PANEL_VERTICAL,
		NULL);

	register_text = (Textsw) xv_create(register_frame, TEXTSW,
					 XV_WIDTH, THE_WIDTH,
					 WIN_BELOW, register_panel,
				       	 XV_X,	0,
					 XV_HEIGHT, 180,
					 TEXTSW_READ_ONLY, TRUE,
					 NULL);



/* prepare mail instruction */

	sprintf(sys_buff, "%s", MAILER);
	strcat(sys_buff," ");
	strcat(sys_buff, MY_ADDRESS);
	strcat(sys_buff, " < ");
	strcat(sys_buff, fname);


	add_text("Welcome to Robot!");
	add_blank();
	add_text("For statistical purposes I'd like to know of program use.");
	add_text("Would you like to register this copy of robot?");
	add_text("(No unsolicited email will ever be sent to you in reply");
	add_text("and your email address will be kept private.)");
	add_blank();
	add_text("If you accept, this program will do:");
	add_blank();
	add_text(sys_buff);
	add_blank();
	add_text("The level of continued development of robot will depend on");
	add_text("the number of registrations on each platform.");

	textsw_normalize_view(register_text, 0);

	xv_set(register_panel,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		NULL);

	xv_create(register_panel, PANEL_BUTTON,
		XV_HELP_DATA,		"robot:register_me",
		PANEL_LABEL_STRING,	"Send Mail to Register",
		PANEL_NOTIFY_PROC,	register_me,
		NULL);

	xv_create(register_panel, PANEL_BUTTON,
		XV_HELP_DATA,		"robot:dont_register_me",
		PANEL_LABEL_STRING,	"Don't Send Mail",
		PANEL_NOTIFY_PROC,	dont_register_me,
		NULL);


	window_fit(register_text);
	window_fit(register_frame);

	xv_set(register_frame, XV_SHOW, TRUE, NULL);
	xv_set(register_frame, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);



}
