.\" tian's man page.
.TH TSESSREG 1 "Jan 17 1997" "Lucent Technologies "
.SH NAME
tsessreg \- manage Solaris2's utmpx/wtmpx entries for non-init clients
.SH SYNOPSIS
.B tsessreg
[-w \fIwtmpx-file\fP]
[-u \fIutmpx-file\fP]
[-l \fIline-name\fP]
[-h \fIdisplay-name\fP]
[-x \fIxslot-start\fP]
[-p \fIxdm-pid\fP]
[-a]
[-d]
[\fIuser-name\fP]
.SH DESCRIPTION
.PP
\fITsessreg\fP is a substitution for \fIX11R6.1\fP's \fIsessreg\fP(1)
program for managing utmpx/wtmpx entries for xdm sessions on
\fISolaris2\fP. \fISessreg\fP(1) can only handle utmp/wtmp files.
Although in \fISolaris2\fP's man pages, \fIfinger\fP(1), \fIlast\fP(1)
and \fIwho\fP(1) are said only need utmp/wtmp files, actually they
rely on utmpx/wtmpx files which containing more information such as
the remote host.
.PP
\fITsessreg\fP is safer than \fIX11R6.1\fP's \fIsessreg\fP(1) in
sense that it makes use of the file lock facilities which avoids
the racing problem.
.PP
I have tried to make \fItsessreg\fP's interface close to 
\fIssessreg\fP(1) so that the user could refer to \fIsessreg\fP(1)
when confused.  The \fIuser-name\fP for \fItsessreg\fP is not 
required now because \fIxdm\fP(1) will set an USER environment 
variable which is the default value. Similarly the default value for 
\fIdisplay-name\fP is $DISPLAY. The default values for \fIwtmpx-file\fP
 and \fIutmpx-file\fP are changed to "/var/adm/wtmpx" and "/var/adm/utmpx". 
.PP
If you call \fItsessreg\fP in \fIxdm\fP(1)'s \fIXstartup\fP and
\fIXreset\fP scripts, you can use \fItsessreg\fP without arguements.
However, i suggest you to specify \fIline-name\fP which will make 
things more meaningful. 
.SH OPTIONS
I have made most the options following \fIssessreg\fP(1)'s convention.
Exceptions are:
.IP "\fB-h\fP \fIdisplay-name\fP"
This specifies the text to be shown as remote host when you use
\fIfinger\fP(1), \fIlast\fP(1) or \fIwho\fP(1). It suggest you just
use its default value which is $DISPLAY.
.IP "\fB-l\fP \fIline-name\fP"
This specifies and special file as a virtual tty for \fIxdm\fP(1)
because xdm communicate through tcp/ip port. Without it, you won't
get an entry in \fIfinger\fP(1)'s output. I did this: mkdir 
/dev/xdm; and then set the \fIline-name\fP as /dev/xdm/\fIxdm-pid\fP 
which is a symbolic link to /dev/null. (see ln(1)).
.IP "\fB-p\fP \fIxdm-pid\fP"
This specifies the pid of the xdm instance which authenticated your
login. It's the pid of the parent process of \fIXstartup\fP and
\fIXreset\fP. You can make a simple script or use my \fItppid\fP(1)
or \fPppid\fP to find it.
.IP "\fB-x\fP \fIxslot-start\fP"
This is a positive integer (default 300). It is the number of the entry
below which we will log the xdm authenticated sessions. putting them in a
specific area will save CPU time when searching them. I set its range
as 100 through 600 inclusive to avoid misusing.
.SH "SEE ALSO"
xdm(1), sessreg(1), tppid(1), fwtmpx(1), update_utmpx(1), utmpx(4)
.SH "BUGS"
No bug has been found yet.
Note: this program is serving as a patch for X11R6's xdm on Solaris2 so it's
only appliable on Solaris2 machines. I have tried it on X11R5; but it seems 
you will need add a patch for
X11R5's xdm in advance because i found my X11R5's xdm couldn't 
handle well the the transition from root's Xstartup to the user's Xsession 
and then back to root's Xreset. i got error message 'permission denied'.
To show this problem. To show this problem you can recompile my
source code of \fItsessreg\fP with -DDEBEUG option and run it with
X11R5's xdm.
.SH AUTHOR
Tianhua Han, Lucent Technology, \fIthan@lucent.com\fP
