.\" tian's man page.
.TH XWALL 5 "Jan 25 1997" "Lucent Technologies "
.SH NAME
xwall \- X wall protocol version 1.1
.SH SYNOPSIS
.nf
         <input_stream> ::= [ [<data>]* <end> ]+
                 <data> ::= <date>|<sender>|<host>|<receiver>]|<subject>|<message>
                 <date> ::= date     [^"]*  '"'  <string>  '"'
               <sender> ::= sender   [^"]*  '"'  <string>  '"'  
                 <host> ::= host     [^"]*  '"'  <string>  '"'  
             <receiver> ::= receiver [^"]*  '"'  <string>  '"'  
              <subject> ::= subject  [^"]*  '"'  <string>  '"'
              <message> ::= message  [^"]*  '"'  <string>  '"'
               <string> ::= [<element>]*
              <element> ::= [^"] | [ '\'  '"' ]
                 <end> ::= quit
.SH NOTE
In the xwall(1)/xwalld(1) implementation, the input stream must contain 
at least one of the subject or message.
.PP
In X wall protocol version 1.1, a new entry 'host' is added.
.SH "EXAMPLES"
The following are legal inputs.
.nf

     sender"rob"date"Sat Jan 25 21:30:00 EST 1997"(Newline)
     message"Has anybody seen john?(Newline)
     please tell him a custmer needing his help.(Newline)
     thank you for your help"quit

     subject'this is a comment and will be discarded'"help"(Newline)
     date"monday"(Newline)
     message"\\"testmachine\\" panic'ed(Newline)". 
     sender"steve"(Newline)
     receiver"tian"(Newline)
     quit
.fi
.SH "SEE ALSO"
xwall(1), xwalld(1)
.SH AUTHOR
Version 1.1 and1.0 by Tianhua Han, Lucent Technology, \fIthan@lucent.com\fP
