/* obj_buildf.c - miscellaneous stuff - will be broken up soon */

/*  Copyright 1991 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

char ups_obj_buildf_c_sccsid[] = "@(#)obj_buildf.c	1.31 04 Jun 1995 (UKC)";

#include <mtrprog/ifdefs.h>

#include <stdlib.h>
#include <stdio.h>

#include <local/wn.h>
#include <local/obj/obj.h>
#include <local/menu3.h>
#include <local/ukcprog.h>
#include <mtrprog/utils.h>

#include "ups.h"
#include "symtab.h"
#include "target.h"
#include "st.h"
#include "objtypes.h"
#include "obj_buildf.h"
#include "obj_misc.h"
#include "obj_target.h"
#include "obj_bpt.h"
#include "obj_signal.h"
#include "obj_env.h"
#include "obj_stack.h"
#include "va.h"
#include "ui.h"
#include "exec.h"
#include "expr.h"
#include "state.h"
#include "menudata.h"
#include "tdr.h"

static const char *gen_getobjname PROTO((objid_t code));
static void init_objtype PROTO((int objtype, const char *format, ot_t *ot,
				bool have_window));

static bool  Src_header_header_exists = FALSE; 

#define BUILTIN_MENUS	/* define for compiled in menu files */

/* Menus
 */
#ifdef BUILTIN_MENUS
extern MENU core_men;		/* target menu */
extern MENU bph_men;		/* breakpoint header menu */
extern MENU bpt_men;		/* breakpoint menu */
extern MENU fun_men;		/* function menu */
extern MENU block_men;		/* block menu */
extern MENU fil_men;		/* source file menu */
extern MENU sh_men;		/* source file header menu */
extern MENU var_men;		/* variable menu */
extern MENU sgh_men;		/* signal header menu */
extern MENU envhead_men;	/* environment header menu */
extern MENU sig_men;		/* signal menu */
extern MENU env_men;		/* environment menu */
extern MENU gbl_men;		/* globals menu */
extern MENU cbh_men;		/* common block header menu */
extern MENU cblock_men;		/* common block menu */
extern MENU mfunc_men;		/* module function menu */
#endif

ot_t Objtab[] = {
#define OT_COM		0
	      { &core_men, "target", "menus/tgtmen.c", -1,
		NULL, do_target, NULL, Com_format, Com_fdefs, Com_fnamemap,
		gen_select, can_select, free_com, NULL, NULL,
		gen_getobjname, target_format_obj },

#define OT_GLOBALS	1
	      { &gbl_men, "globals", "menus/gblmen.c", -1,
		NULL, do_globals, NULL, Globals_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_SRCHEAD	2
	      { &sh_men, "srchead", "menus/shmen.c", -1,
		NULL, do_srchead, NULL, Srchead_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_SFILE	3
	      { &fil_men, "source", "menus/filmen.c", -1,
		pre_do_file, do_file, NULL, Sfile_format, NULL, NULL,
		gen_select, can_select, NULL, srcfile_getsize, srcfile_getcolor,
		srcfile_getobjname, file_format_obj },
	
#define OT_FHEAD	4
	      { NULL, "stack", NULL, -1,
		NULL, NULL, NULL, Fhead_format, NULL, NULL,
		NULL, cannot_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },

#define OT_FUNC		5
	      { NULL, "function", NULL, OT_SFILE,
		pre_do_func, do_func, NULL, Func_format, Func_fdefs, NULL,
		gen_select, can_select, free_func, NULL, func_getcolor,
		func_getobjname, func_format_obj },

#define OT_BLOCK	6
	      { &block_men, "block", "menus/blockmen.c", -1,
		pre_do_block, do_block, NULL, Block_format, NULL, NULL,
		gen_select, can_select, free_block, NULL, NULL,
		block_getobjname, block_format_obj },

#define OT_FSIG		7
	      { NULL, "*fsig", NULL, -1,
		NULL, NULL, NULL, Fsig_format, Fsig_fdefs, NULL,
		NULL, cannot_select, free_fsig, NULL, NULL,
		gen_getobjname, fsig_format_obj },
	
#define OT_BADFUNC	8
	      { NULL, "*badfunc", NULL, -1,
		NULL, NULL, NULL, Badfunc_format, NULL, NULL,
		NULL, cannot_select, free_badfunc, NULL, NULL,
		gen_getobjname, badstack_format_obj },
	
#define OT_BADFRAME	9
	      { NULL, "*badframe", NULL, -1,
		NULL, NULL, NULL, Badfunc_format, NULL, NULL,
		NULL, cannot_select, free_badfunc, NULL, NULL,
		gen_getobjname, badstack_format_obj },
	
#define OT_VAR		10
	      { &var_men, "var", "menus/varmen.c", -1,
		NULL, do_var_or_expr, NULL, Var_format, Var_fdefs, Var_fnamemap,
		gen_select, can_select, free_displayed_var, NULL, var_getcolor,
		var_getobjname, var_format_obj },
	
#define OT_EXPR		11
	      { NULL, "expr", NULL, OT_VAR,
		NULL, do_var_or_expr, NULL,
			Expr_format, Expr_fdefs, Expr_fnamemap,
		gen_select, can_select, free_displayed_expr, NULL, expr_getcolor,
	        expr_getobjname, expr_format_obj },

#define OT_BPHEAD	12
	      { &bph_men, "bphead", "menus/bphmen.c", -1,
		NULL, do_bps, NULL, Bphead_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_BPT		13
	      { &bpt_men, "bpt", "menus/bptmen.c", -1,
		pre_do_bpt, do_bpt, post_do_bpt,
	        Bpt_format, Bpt_fdefs, Bpt_fnamemap,
		gen_select, can_select, remove_breakpoint_object, NULL,
		bpt_getcolor, bpt_getobjname, bpt_format_obj },

#define OT_SGHEAD	14
	      { &sgh_men, "sghead", "menus/sghmen.c", -1,
		NULL, do_sgh, NULL, Sghead_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_SIG		15
	      { &sig_men, "signal", "menus/sigmen.c", -1,
		NULL, do_sig, NULL, Sig_format, NULL, NULL,
		gen_select, can_select, free_sig, sig_getsize, sig_getcolor,
		sig_getobjname, sig_format_obj },

#define OT_CBHEAD	16
	      { &cbh_men, "cbhead", "menus/cbhmen.c", -1,
		NULL, do_cbhead, NULL, Cbhead_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_CBLOCK	17
	      { &cblock_men, "cblock", "menus/cblockmen.c", -1,
		NULL, do_cblock, NULL, Cblock_format, NULL, NULL,
		gen_select, can_select, free_common_block_object, NULL, NULL,
		cblock_getobjname, cblock_format_obj },

#define OT_MHEAD	18
	      { NULL, "mhead", NULL, OT_CBHEAD,
		NULL, do_mhead, NULL, Mhead_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_MODULE	19
	      { NULL, "module", NULL, OT_CBLOCK,
		NULL, do_module, NULL, Module_format, NULL, NULL,
		gen_select, can_select, NULL, module_getsize, NULL,
		module_getobjname, module_format_obj },

#define OT_MODULE_FUNC	20
	      { &mfunc_men, "module-func", "menus/mfuncmen.c", -1,
		NULL, do_module_func, NULL, Module_func_format, NULL, NULL,
		gen_select, can_select, NULL, module_func_getsize, NULL,
		module_func_getobjname, module_func_format_obj },

#define OT_ENVHEAD	21
	      { &envhead_men, "envhead", "menus/envheadmen.c", -1,
		NULL, do_envhead, NULL, Envhead_format, NULL, NULL,
		gen_select, can_select, NULL, NULL, NULL,
		gen_getobjname, header_format_obj },
	
#define OT_ENV		22
	      { &env_men, "env", "menus/envmen.c", -1,
		NULL, do_env, NULL, Env_format, Env_fdefs, Env_fnamemap,
		gen_select, can_select, free_env, env_getsize, env_getcolor,
		env_getobjname, env_format_obj },
};

#define OT_MAXTYPE	22
#define N_OBJTYPES (sizeof(Objtab) / sizeof(Objtab[0]))

#define CHILD_INDENT	20	/* RGA not used now */

static const char *
gen_getobjname(code)
objid_t code;
{
	int objtype;

	objtype = ups_get_object_type(code);

	if (objtype < 0 || objtype >= N_OBJTYPES)
		panic("ot botch in ggn");

	return Objtab[objtype].ot_menuname;
}

void
do_formats(have_window)
bool have_window;
{
	fdef_t *fdef;
	register ot_t *ot;

	init_objects();

	if (have_window) {
		font_t *sysfont;

		sysfont = wn_get_sysfont();
		set_field_scale_factors(sysfont->ft_width, sysfont->ft_height);
	}

	for (ot = Objtab; ot < Objtab + N_OBJTYPES; ot++) {
		fdef = ot->ot_fdefs;
		if (fdef != NULL) {
			for (; fdef->fd_char != '\0'; fdef++)
				define_vsformat(fdef->fd_char,
						fdef->fd_edit,
						fdef->fd_draw,
						fdef->fd_getwidth);
		}
	}

	for (ot = Objtab; ot < Objtab + N_OBJTYPES; ot++) {
		if (have_window && ot->ot_men != NULL) {
#ifdef BUILTIN_MENUS
			ot->ot_md = Minsert((MENU *)ot->ot_men);
#else
			ot->ot_md = Mopen(ot->ot_menupath);
#endif
			if (ot->ot_md == -1) {
				Mperror("Mopen");
				exit(1);
			}
			Mnobox(ot->ot_md);
		}

		init_objtype(ot - Objtab, ot->ot_format, ot, have_window);
	}

	/*  An objtype with ot_men NULL and ot_md != -1 means that the
	 *  objtype shares a menu with objtype ot_md.
	 */
	for (ot = Objtab; ot < Objtab + N_OBJTYPES; ++ot) {
		if (ot->ot_men == NULL && ot->ot_md != -1)
			ot->ot_md = Objtab[ot->ot_md].ot_md;
	}

	/*  Do the OT_SFILE_EX and OT_MODULE_EX special cases.
	 */
	init_objtype(OT_SFILE_EX, Sfile_ex_format, &Objtab[OT_SFILE],
		     have_window);
	init_objtype(OT_MODULE_EX, Module_ex_format, &Objtab[OT_MODULE],
		     have_window);
}

static void
init_objtype(objtype, format, ot, have_window)
int objtype;
const char *format;
ot_t *ot;
bool have_window;
{
/* RGA make CHILD_INDENT an exact multiple of font width so display */
/* overlay matches */

	define_objtype(objtype, format, have_window ?
		       3*wn_get_sysfont()->ft_width : CHILD_INDENT,
		       ot->ot_select, ot->ot_can_select,
		       ot->ot_free, ot->ot_get_size, ot->ot_get_color);
	set_objtype_get_name_func(objtype, ot->ot_get_name);
	set_objtype_format_func(objtype, ot->ot_format_func);
}
	
void
close_target_display()
{
	delete_functions(FHEAD_OBJCODE);
	remove_object(GLOBALS_OBJCODE, OBJ_DESCENDENTS);
	
	if (obj_child_exists((objid_t)NULL, CBHEAD_OBJCODE)) {
		objid_t obj;

		for (obj = get_code(CBHEAD_OBJCODE, OBJ_CHILD);
		     obj != NULL;
		     obj = get_code(obj, OBJ_NEXT)) {
			remove_object(obj, OBJ_DESCENDENTS);
		}
	}

	hide_source_vars();
}

objid_t
rebuild_display(xp)
target_t *xp;
{
	objid_t obj_to_make_visible;

	clear_selection();
	obj_to_make_visible = add_functions(xp, FHEAD_OBJCODE);
	update_variable_values();
#ifdef OS_SUNOS_5
	if (xp->xp_new_dynamic_libs == TRUE)
	{
	  mark_duplicate_files();
	  xp->xp_new_dynamic_libs = FALSE;
	}
	if (xp->xp_restore_bpts == TRUE)
	{
	  elf_restore_symtab_breakpoints();
	  xp->xp_restore_bpts = FALSE;
	}
#endif /* OS_SUNOS_5 */

	return obj_to_make_visible;
}

void
update_variable_values()
{
	objid_t obj;

	update_local_variable_values();

	update_vars_of(GLOBALS_OBJCODE, FALSE);

	if (obj_child_exists((objid_t)NULL, CBHEAD_OBJCODE)) {
		for (obj = get_code(CBHEAD_OBJCODE, OBJ_CHILD);
		     obj != NULL;
		     obj = get_code(obj, OBJ_NEXT)) {
			update_vars_of(obj, FALSE);
		}
	}

	for (obj = get_code(SRCHEAD_OBJCODE, OBJ_CHILD);
	     obj != NULL;
	     obj = get_code(obj, OBJ_NEXT)) {
		update_vars_of(obj, FALSE);
	}
}

void
initialise_display_area(xp, args, use_full_path)
target_t *xp;
const char *args;
bool use_full_path;
{
	symtab_t *st;
	bool have_common_blocks, have_modules;

	have_modules = have_common_blocks = FALSE;

	st = NULL;
	while (xp_next_symtab(xp, st, FALSE, &st)) {
		if (st->st_cblist != NULL)
			have_common_blocks = TRUE;
		if (st->st_modules != NULL)
			have_modules = TRUE;
	}

	add_breakpoint_header((objid_t)NULL);
	
	new_object(FHEAD_OBJCODE, OT_FHEAD, (objid_t)NULL, OBJ_CHILD);
	
	if (have_common_blocks)
		new_object(CBHEAD_OBJCODE, OT_CBHEAD, (objid_t)NULL, OBJ_CHILD);

	if (have_modules)
		new_object(MHEAD_OBJCODE, OT_MHEAD, (objid_t)NULL, OBJ_CHILD);
		
	new_object(SRCHEAD_OBJCODE, OT_SRCHEAD, (objid_t)NULL, OBJ_CHILD);
	Src_header_header_exists = TRUE; 
	/* RGA - ugh, but can't do collapse_files if this */
	/* has not been done */
	add_globals_header((objid_t)NULL);
	add_env_header((objid_t)NULL);
	add_signals_header((objid_t)NULL);

	if (can_get_target_vars(xp))	
		add_functions(xp, FHEAD_OBJCODE);

	add_target_object((objid_t)NULL, xp->xp_textpath, args, use_full_path);
}

void
  collapse_files()
{
  int oldstate;

  if (Src_header_header_exists == TRUE)
  {
    oldstate = td_set_obj_updating(OBJ_UPDATING_OFF);
    do_srchead(SRCHEAD_OBJCODE, MR_HIDE_SOURCE_FILES_COMPLETELY, NULL);
    td_set_obj_updating(oldstate);
  }
}
