static char SCCSID[] = "@(#)main.c	1.2 89/02/13";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

/*
 * xbench
 *
 * measure performance
 *
 * written Feb. '89 by claus
 */
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "patchlevel.h"

Display *dpy;
Window  rootWin, win;
int     sync;
int     screen;
int     screenWidth, screenHeight;
int     onlyCount, exclCount;
char    *onlyList[100];
char    *exclList[100];
/*
 * since the bench is really a graphics benchmark,
 * I do not want to have daemons (rwhod ...) and other stuff
 * like that to disturb me.
 * since I cannot remove them, best I can do is to run the
 * benchmarks more than once and take the BEST time - not the
 * average. This minimizes the influence of sync. rwhod etc...
 *
 * the number of runs is defined below.
 * since every run takes about 10 sec's, this gives 30 secs for every
 * test.
 */
static int nruns = 3;

main(argc,argv)
    int argc;
    char **argv;
{
	Visual               visual;
	XSetWindowAttributes xswa;
	int                  timeGoal = 10;
	char                 **ap;
	char                 *cp;
	char                 *displayName = NULL;
	XSizeHints           szhint;
	int                  list = 0;
	int                  ask = 0;
	int                  level = 1;
	int                  ac;

	sync = 0;
	onlyCount = 0;
	exclCount = 0;
	for (ap = &argv[1], ac=argc-1; ac; ac--) {
	    cp = *ap++;
	    if (strcmp(cp, "-display") == 0) {
		displayName = *ap++; ac--;
	    } else if (strcmp(cp, "-level") == 0) {
		cp = *ap++; ac--;
		sscanf(cp, "%d", &level);
	    } else if (strcmp(cp, "-nruns") == 0) {
		cp = *ap++; ac--;
		sscanf(cp, "%d", &nruns);
	    } else if (strcmp(cp, "-timegoal") == 0) {
		cp = *ap++; ac--;
		sscanf(cp, "%d", &timeGoal);
	    } else if (strcmp(cp, "-sync") == 0) {
		sync++;
	    } else if (strcmp(cp, "-ask") == 0) {
		ask++;
	    } else if (strcmp(cp, "-help") == 0) {
		list++;
	    } else if (strcmp(cp, "-only") == 0) {
		onlyList[onlyCount++] = *ap++; ac--;
		level = 99;
	    } else if (strcmp(cp, "-not") == 0) {
		exclList[exclCount++] = *ap++; ac--;
	    } else
		usage();
	}

	onlyList[onlyCount] = NULL;
	exclList[exclCount] = NULL;

	if ((level<1) || list) {
	    listBenches();
	    exit(0);
	}

	dpy = XOpenDisplay(displayName);
	if ( dpy == NULL ) {
	    fprintf(stderr, "can't open DISPLAY \n");
	    exit(1);
	}

	screen = DefaultScreen(dpy);
	screenWidth = DisplayWidth(dpy, screen);
	screenHeight = DisplayHeight(dpy, screen);
	rootWin = RootWindow(dpy, screen);

	serverinfo(dpy, timeGoal);

	/*
	 * create a full screen window ..
	 */
	visual.visualid = CopyFromParent;
	xswa.backing_store = NotUseful;
	xswa.event_mask = StructureNotifyMask;
	xswa.background_pixel = BlackPixel(dpy, screen);
	xswa.override_redirect = True;
	win = XCreateWindow(dpy, rootWin,
				0, 0, screenWidth, screenHeight,
				0,
				DefaultDepth(dpy, screen),
				InputOutput, &visual,
				CWEventMask | CWBackPixel |
					      CWOverrideRedirect,
				&xswa);

	if (win == (Window)0) {
	    fprintf(stderr, "can't create window\n");
	    exit(1);
	}
	szhint.flags = PSize | PPosition;
	szhint.x = 0;
	szhint.y = 0;
	szhint.width = screenWidth;
	szhint.height = screenHeight;
	XSetStandardProperties(dpy, win, "xbench", "should not be iconified",
			       (Pixmap)0, argv, argc, &szhint);

	XSync(dpy, 0);

	doBenches(dpy, win, ask, nruns, timeGoal, level, onlyList, exclList);

	XCloseDisplay(dpy);
	exit(0);
}

usage() {
	fprintf(stderr, "usage: xbench [options]\n");
	fprintf(stderr, "  allowed options:\n");
	fprintf(stderr, "    -display name  ................. define server\n");
	fprintf(stderr, "    -level number (default 1) ...... define number of tests made\n");
	fprintf(stderr, "    -timeGoal seconds (default 10) . runtime per test\n");
	fprintf(stderr, "    -nruns number (default 3) ...... runs per test\n");
	fprintf(stderr, "    -help .......................... print list of available tests\n");
	fprintf(stderr, "    -only testname ................. run named test only\n");
	fprintf(stderr, "    -not testname .................. do not run named test\n");
	fprintf(stderr, "    -ask ........................... interactive mode\n");
	fprintf(stderr, "    -sync .......................... sync for slow operations\n");
	exit(1);
}

serverinfo(dpy, timeGoal)
Display *dpy;
{
	char buffer[128];

	printf("==================================================\n");
	printf("GENERAL INFORMATION\n");
	printf("\n");
	fprintf(stderr, "describe brand/configuration of SERVER machine (1 line)\n");
	fprintf(stderr, "(example: XYZ-891 with steam-engine [return]\n");
	gets(buffer);
	printf("server: %s\n", buffer);
	fprintf(stderr, "describe brand/configuration of CLIENT machine (1 line)\n");
	gets(buffer);
	printf("client: %s\n", buffer);
	fprintf(stderr, "describe communication used (1 line)\n");
	fprintf(stderr, "(example: 10Mb ether or 19600 slip ..)\n");
	gets(buffer);
	printf("communication: %s\n", buffer);
	fprintf(stderr, "any additional notes (1 line)\n");
	gets(buffer);
	printf("notes: %s\n", buffer);
	printf("\n");
	printf("==================================================\n");
	printf("SERVER INFORMATION\n");
	printf("\n");
	printf("Servervendor            : %s\n",ServerVendor(dpy));
	printf("XSERVER version         : %d.%d\n",ProtocolVersion(dpy), VendorRelease(dpy));
	printf("Revision                : %d\n",ProtocolRevision(dpy));
	printf("Defaultdepth rootwindow : %d\n",DefaultDepth(dpy,0));
	printf("Server Byte-Order       : %s\n",((ImageByteOrder(dpy)
		        == MSBFirst) ?	"MSBFirst" : "LSBFirst" ));
	printf("Server BitmapBitOrder   : %s\n",((BitmapBitOrder(dpy)
		 == MSBFirst) ?	"MSBFirst" : "LSBFirst" ));
	printf("DisplayWidth            : %d\n",DisplayWidth(dpy,0));
	printf("DisplayHeight           : %d\n",DisplayHeight(dpy,0));
	printf("\n");
	printf("==================================================\n");
	printf("XBENCH INFORMATION\n");
	printf("VERSION: %d TIMEGOAL = %d sec; NRUNS = %d", 
			PATCHLEVEL, timeGoal, nruns);
	if (sync)
	    printf("; SYNC");
	printf("\n");
	printf("\n");
}
