.TH xdefmap 1 "2nd April 96" "X Version 11"
.SH NAME
xdefmap \- enhanced X standard colormap utility
.SH SYNOPSIS
.B xdefmap
[-display host:dpy] options
.SH DESCRIPTION
.I xdefmap
is a tool similar to xstdcmap. It's main purpose is to install or delete
standard colormaps. In contrast to xstdcmap, the main idea in this tool
is to install maps that consist of read-only pixels into the default
(pseudo) colormap of the display. It is also possible to arbitrary define
the sizes of those maps.
.PP
There is also an easy method to create XCMS-database files so
that even applications that don't yet know anything of standard colormaps,
can share the pixels.
.PP
Additionaly there are some information functions contained in the program
to give the color administrator :-) full control over it's maps.
.PP
.SH "OPTIONS"
The option are therefore separated into the following subsections:
.SS "INSTALLATION OF COLORMAPS"
.TP 12
.B -best
make the RGB_BEST_MAP
.TP
.B -default
make the RGB_DEFAULT_MAP
.TP
.B -gray
make the RGB_GRAY_MAP
.TP
.B -red
make the RGB_RED_MAP
.TP
.B -green
make the RGB_GREEN_MAP
.TP
.B -blue
make the RGB_BLUE_MAP
.TP
.B -s \fR<\fIn\fR>
select the number of intensities for the desired map. Allocates <n>x<n>x<n>
colors, when best or default map are selected.
.TP
.B \fR<\fIr\fR><\fIg\fR><\fIb\fR>
select a special colordistribution for best and default maps, so that <r>x<g>x<b>
colors have to be allocated
.TP
.B -delete \fR<\fImap\fR>
delete the selected map
.SS "VISUALISATION OF THE COLORMAP"
.TP
.B -top, -right, bottom, -left
create an information window with the current color palette at the desired
edge of the screen.
.TP
.B -hide
hide the information window
.TP
.B -s \fR<\fIn\fR>
sets width or height of the information window to n pixels
.TP
.B -set \fR[<\fIcolor1\fR> <\fIcolor2\fR>]
visualize unused colors in the information window by temporary setting
the unallocated pixels
.TP
.B -wait
allocate all unused cells and keep them allocated to check the handling
of other applications, when there are no more cells available
.SS "XCMSDB SUPPORT"
.TP
.B -lookup
looks up rgb-values for the colornames entered from stdin and creates a
XCMSDB-file containing the closest entries found in the installed colormaps for
those colors
.TP
.B -parse \fR[<\fIrgb-file\fR>]
parses a file in the format of the rgb.txt-file (default: \fI/usr/lib/X11/rgb.txt\fP)
and create a XCMSDB-file with all entries.
.TP
.B -f \fR<\fIfilename\fR>
write XCMSDB-file to <filename> instead of writing to stdout
.SS "MAP FILES"
.TP
.B -stdmap \fR<\fIppmfile\fR>
write colorinformation of installed colormaps into a file in ppm-format to
be used as map-file in ppmquant(1)
.TP
.B -map \fR<\fIppmfile\fR>
write colorinformation of all shared colors into a file in ppm-format to
be used as map-file in ppmquant(1)
.SS "OTHERS"
.TP
.B -q
query information about the current usage of color cells and standard
colormaps
.TP
.B -v
be verbose, e.g. give information about pixels, that couldn't be allocated
read-only when installing a map.
.SH EXAMPLES
.TP
.B xdefmap -best 443 -v
Install RGB_BEST_MAP with the size 4x4x3 = 48 colors and check, if there
were many duplicates, so that read/write colors had to be used.
.TP
.B xdefmap -red 16
install RGB_RED_MAP with 16 intensities
.TP
.B xdefmap -best -parse > Xcms.txt
transform the whole rgb.txt-file into a XCMSDB-database with alias names to
get the closest color in the best map. The file
can be used by letting the XCMSDB environment variable point to it. In that way
all allocations with standard names (not rgb-names) will point into the
standard map.
.TP
.B xdefmap -set green red
preset all unallocated entries with a colorbow from green to red.

.SH FILES
/usr/lib/X11/rgb.txt
.SH "SEE ALSO"
X(1), xstdcmap(1), XGetRGBColormaps(3), ppm(1), ppmquant(1), flying(6:-)
.SH BUGS
The program is currently only designed for displays with an pseudo-color
default visual with 256 colors.
.PP
Installing standard colormaps in separate colormaps is not handled.
.PP
There is a discrepancy between the defininition of gray-maps (where only
reds should be used) and the implementation in xstdcmap. Since xstdcmap
approach helps the application (and ImageMagick is the only package
that I currently have to test it) I also implemented the xstdcmap way, but
another option might be a better way.
.PP
As a special feature, BEST and DEFAULT map can share their pixels, if they
are defined with the same sizes. This colormap twin can not correctly be
deleted by xstdcmap, since only one of the 2 maps really has the
colors reserved.

.SH COPYRIGHT
Copyright 1995, Helmut Hoenig, Heiligenhaus/Bad Camberg
.TP 8
email (for any comments):
Helmut.Hoenig@hub.de
.TP 5
smail (for gifts):
   Helmut Hoenig
   Hopfenstrasse 8a
   65520 Bad Camberg
   GERMANY
.PP
Permission to use, copy, modify, and distribute this
software for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies.
