/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XMG_H
#define XMG_H		1

#include "a.h"

typedef struct		_XmgPixelRec
{
  Pixel			pixel;
  Colormap		cmap;
} XmgPixelRec;

#define AnyDepth	0

typedef struct		_XmgPixmapRec
{
  Pixmap		pixmap;
  int			depth;
} XmgPixmapRec;

/* PROTO Xmg.c */
/* Xmg.c */
void XmgActionNop P((Widget w, XEvent *event, String *params, Cardinal *num_params));
void XmgActionPopdown P((Widget w, XEvent *event, String *params, Cardinal *num_params));
void XmgActionDestroy P((Widget w, XEvent *event, String *params, Cardinal *num_params));
void XmgActionSetFocus P((Widget w, XEvent *event, String *params, Cardinal *num_params));
void XmgPopdown P((Widget widget));
void XmgActionPopdownAllMenus P((Widget w, XEvent *event, String *params, Cardinal *num_params));
void XmgActionPopdownAllMenusAfterMe P((Widget w, XEvent *event, String *params, Cardinal *num_params));
void XmgSetDestroyOnDelete P((Widget w));
void XmgSetPopdownOnDelete P((Widget w));
void XmgSetNopOnReturn P((Widget w));
void XmgWarning P((char *fmt, ...));
void XmgCenterWidget P((Widget w));
void XmgTallyWidgetWithScreen P((Widget w));
t_status XmgInit P((void));
t_status XmgXFSDictAdd P((char *name, XFontStruct *xfs));
t_status XmgXFSDictGet P((char *name, XFontStruct **xfs));
t_status XmgPixelDictAdd P((char *name, Colormap cmap, Pixel pixel));
t_status XmgPixelDictGet P((char *name, int cmap, Pixel *pixel_ret));
t_status XmgPixmapDictAdd P((char *name, int depth, Pixmap pixmap));
t_status XmgPixmapDictGet P((char *name, int depth, Pixmap *pixmap_ret));
t_status XmgPixmapDictForceGet P((Display *display, char *name, int depth, Pixmap *pixmap_ret));
t_status XmgDestroyPixmapDictWalk P((t_hash_elt *he, void *unused));
t_status XmgDestroyXFSDictWalk P((t_hash_elt *he, void *unused));
t_status XmgDestroyPixelDictWalk P((t_hash_elt *he, void *unused));
void XmgDestroy P((void));
void XmgShowRect P((XRectangle *rect));
t_status XmgPixmapDictStatusWalk P((t_hash_elt *he, void *unused));
void XmgStatus P((void));
#endif
