/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XMGFANCYI_H
#define XMGFANCYI_H	1

#include "xmg_i.h"

/*#define FANCY_DEBUG_MALLOC	1*/

#ifdef FANCY_DEBUG_MALLOC
#define FANCY_ALLOC_ALGORITHM	alloc_algorithm_factor2
#define FANCY_ALLOC_PROC	fancy_alloc
#define FANCY_REALLOC_PROC	fancy_realloc
#define FANCY_FREE_PROC		fancy_free
#else
#define FANCY_ALLOC_ALGORITHM	XMG_ALLOC_ALGORITHM
#define FANCY_ALLOC_PROC	XMG_ALLOC_PROC
#define FANCY_REALLOC_PROC	XMG_REALLOC_PROC
#define FANCY_FREE_PROC		XMG_FREE_PROC
#endif

#define FANCY_VEC_NEW(VecBase,StatusPtr)	vec_new((VecBase),\
							FALSE,\
							FANCY_ALLOC_ALGORITHM,\
							FANCY_ALLOC_PROC,\
							FANCY_REALLOC_PROC,\
							FANCY_FREE_PROC,\
							"fancy_vec",\
							(StatusPtr))

#define FANCY_DICT_NEW(HashBase,VecBase,StatusPtr)	dict_new((HashBase),\
								 (VecBase),\
							dict_hash_code_public,\
							FANCY_ALLOC_ALGORITHM,\
							FANCY_ALLOC_PROC,\
							 FANCY_REALLOC_PROC,\
							 FANCY_FREE_PROC,\
							     "fancy_dict",\
								 (StatusPtr))

#endif
