/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * Copyright Olivier Raoul (C) 1995
 */

#ifndef XT_MACRO_H
#define XT_MACRO_H

#include <X11/Intrinsic.h>
#include "a.h"

typedef VOID_FUNC			(*XmgMCallbackProc) P((Widget w,
							       t_vec *args,
							       XtPointer cbs));

typedef struct				s_method_data
{
  Widget				dst;
  String				src_res;
  String				dst_res;
} t_method_data; 

typedef struct				s_trace_data
{
  String				res;
  XtPointer				var;
} t_trace_data;

typedef struct				s_multi_data
{
  XmgMCallbackProc			proc;
  t_vec					*args;
} t_multi_data;

extern VOID_FUNC			_XtVaToTypedArgList();
extern Widget				_XtCreateWidget();
extern Widget				_XtCreatePopupShell();
extern VOID_FUNC			_XtCountVaList();

#define CHILDGENERIC(x)			NULL),x xt_macro_create_widget

#define CHILD				CHILDGENERIC( )

#define CHILDGENERICSHELL(x)		NULL),x xt_macro_create_shell_widget

#define CHILDSHELL			CHILDGENERICSHELL( )

#define GETCHILDSHELL(x)		CHILDGENERICSHELL((x) =)

#define GETCHILD(x)			CHILDGENERIC((x) =)

#define END				NULL),xt_macro_pop_child(),\
					xt_macro_nothing( xt_macro_nothing(

#define INTERFACE			xt_macro_push_child

#define ENDINTERFACE			NULL),xt_macro_pop_child(),\
					xt_macro_lookup_child(

#define GETPARENT			xt_macro_lookup_child()

#define DO				NULL)

#define DONE				xt_macro_nothing( NULL

#define CALLBACK(nam,fun,data)		DO,XtAddCallback(GETPARENT,\
					(nam),(XtCallbackProc)(fun),\
					(XtPointer)(data)),DONE

#define MCALLBACK			DO,xt_macro_add_mcallback

#define EVENTHANDLER(nam,msk,fun,data)	DO,\
					XtAddEventHandler(GETPARENT,\
					(nam),(msk),(XtEventHandler)(fun),\
					(XtPointer)(data)),DONE

#define CALLTRACE(callback,res,val)	DO,\
					xt_macro_do_method_trace\
					(GETPARENT,\
					(callback),(res),(val)),DONE

#define SETTO(target,callback,res)	DO,xt_macro_do_method(\
					GETPARENT,\
					(callback),(res),(target),(res)),DONE

#define GETFROM(src,callback,res)	DO,xt_macro_do_method((src),\
					(callback),(res),\
					GETPARENT,(res)),DONE

#define LINKVAR(w,callback,res)		SETTO((w),(callback),(res)),\
					GETFROM((w),(callback),(res))

#define APPINITIALIZE			xt_macro_app_initialize

#define REALIZE				NULL),\
					XtRealizeWidget(GETPARENT),\
					xt_macro_nothing( NULL

#define MANAGE				NULL),XtManageChild(\
					GETPARENT),\
					xt_macro_nothing( NULL

#define POPUP(type)			NULL),XtPopup(GETPARENT,\
					(type)),xt_macro_nothing( NULL

#define MAINLOOP			DO,XtAppMainLoop(\
					XtWidgetToApplicationContext(\
					GETPARENT)),DONE

#define INSERTCODE(x)			DO;x;DONE
					
/* PROTO xt_macro.c */
/* include/XmgFancyI.h */
/* xt_macro.c */
t_status xt_macro_init P((void));
void xt_macro_destroy P((void));
void xt_macro_push_child P((Widget w, ...));
Widget xt_macro_lookup_child P((void));
void xt_macro_pop_child P((void));
Widget xt_macro_va_create_widget P((Widget (*f)(), String name, WidgetClass widget_class, Widget parent, va_list var, int count));
Widget xt_macro_create_widget P((char *name, WidgetClass widget_class, ...));
Widget xt_macro_create_shell_widget P((char *name, WidgetClass widget_class, ...));
Widget xt_macro_app_initialize P((XtAppContext *app_context_return, String application_class, XrmOptionDescList options, Cardinal num_options, int *argc_in_out, String *argv_in_out, String *fallback_resources, ...));
void xt_macro_method_process_callback P((Widget src, t_method_data *md, XtPointer p));
void xt_macro_trace_process_callback P((Widget src, t_trace_data *td, XtPointer p));
void xt_macro_method_destroy_callback P((Widget src, t_method_data *md, XtPointer p));
void xt_macro_do_method P((Widget src, String callback, String src_res, Widget dst, String dst_res));
void xt_macro_do_method_double P((Widget src, String callback, String src_res, Widget dst, String dst_res));
void xt_macro_do_method_trace P((Widget src, String callback, String res, XtPointer var));
void xt_macro_mcallback_callback P((Widget w, t_multi_data *md, XtPointer cbs));
void xt_macro_mdestroy_callback P((Widget w, t_multi_data *md));
void xt_macro_add_mcallback P((char *name, XmgMCallbackProc proc, ...));
#endif
