/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * 
 */

#include "a.h"

#ifdef DEBUG
int			alloc_algorithm_count = 0;

/* indicates the numbers of calls to the alloc_algorithm_proc. 
   This is a debug function. */
VOID_FUNC		alloc_algorithm_status(VOID_DECL)
{
  fprintf(stderr,"alloc_algorithm_count=%d\n",alloc_algorithm_count);
}
#endif

/* is a t_alloc_algorithm_proc.
   New_size matches exactly request_size.
   Returns always 0 */
t_status		alloc_algorithm_exact(old_size,
					      request_size,
					      new_size)
size_t			old_size;
size_t			request_size;
size_t			*new_size;
{
#ifdef DEBUG
  alloc_algorithm_count++;
#endif
  assert(request_size > old_size);
  (*new_size) = request_size;
  return (0);
}

/* is a t_alloc_algorithm_proc.
   New_size is as many as factor 2 old_size until new_size > request_size.
   Returns always 0 */ 
t_status		alloc_algorithm_factor2(old_size,
						request_size,
						new_size)
size_t			old_size;
size_t			request_size;
size_t			*new_size;
{
  size_t		n;
  
#ifdef DEBUG
  alloc_algorithm_count++;
#endif
  assert(request_size > old_size);
#ifdef NOTDEF
  fprintf(stderr,"old_size=%d request_size=%d\n",old_size,request_size);
#endif
  if (old_size == 0)
    {
      (*new_size) = request_size;
      return (0);
    }
  n = old_size;
  while (n < request_size)
    n *= 2;
  (*new_size) = n;
  return (0);
}

/* is a t_alloc_proc.
   Calls the standard malloc(3).
   Returns a pointer */ 
VOID_PTR		alloc_malloc(size,comment1,comment2,status)
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status; /* -ERR_ZEROLEN if size equals 0, 
				    -ERR_NOMEM is malloc fails */
{
  VOID_PTR		ptr;

  if (size == 0)
    {
      (*status) = -ERR_ZEROLEN;
      return (NULL);
    }
  if ((ptr = malloc(size)) == NULL)
    {
      (*status) = -ERR_NOMEM;
      return (NULL);
    }
#ifdef DEBUG
  bff(ptr,size);
#endif
  return (ptr);
}

/* is a t_realloc_proc.
   Calls the standard realloc(3).
   Returns a pointer */
VOID_PTR		realloc_realloc(old_ptr,size,comment1,comment2,status)
VOID_PTR		old_ptr;
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;
{
  VOID_PTR		ptr;

  if (size == 0)
    {
      (*status) = -ERR_ZEROLEN;
      return (NULL);
    }
  if ((ptr = realloc(old_ptr,size)) == NULL)
    {
      (*status) = -ERR_NOMEM;
      return (NULL);
    }
  return (ptr);
}

/* is a t_free_proc.
   Calls the standard free(3). */
VOID_FUNC		free_free(ptr,comment1,comment2)
VOID_PTR		ptr;
char			*comment1;
char			*comment2;
{
  free(ptr);
}
