/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_ALLOC_H
#define A_ALLOC_H	1

#include "a.h"

typedef t_status	(*t_alloc_algorithm_proc) P((size_t old_size,
						     size_t request_size,
						     size_t *new_size));

typedef VOID_PTR	(*t_alloc_proc) P((size_t size,
					   char *comment1,
					   char *comment2,
					   t_status *status));

typedef VOID_PTR	(*t_realloc_proc) P((VOID_PTR oldptr,
					     size_t size,
					     char *comment1,
					     char *comment2,
					     t_status *status));

typedef VOID_FUNC	(*t_free_proc) P((VOID_PTR ptr,
					  char *comment1,
					  char *comment2));

/* PROTO a_alloc.c */
/* a_alloc.c */
void alloc_algorithm_status P((void));
t_status alloc_algorithm_exact P((size_t old_size, size_t request_size, size_t *new_size));
t_status alloc_algorithm_factor2 P((size_t old_size, size_t request_size, size_t *new_size));
void *alloc_malloc P((size_t size, char *comment1, char *comment2, t_status *status));
void *realloc_realloc P((void *old_ptr, size_t size, char *comment1, char *comment2, t_status *status));
void free_free P((void *ptr, char *comment1, char *comment2));
#endif
