/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_RIP_H
#define LAY_RIP_H	1

#include "layer.h"

typedef struct		s_rip
{
  t_u8			cmd;
  t_u8			v;
  t_u16			mbz;
} t_rip;

#define RIP_HLEN	(sizeof (t_rip))

#define RIP_PORT	520

#define LAYER_RIP_CHECK(rippar,bufpar,lenpar) \
	if ((lenpar) < RIP_HLEN)\
		return (-ERR_TRUNC);\
	(rippar) = (t_rip *)(bufpar);

extern t_assoc		ripcmd_assocs[];

/* PROTO lay_rip.c */
/* lay_rip.c */
t_status rip_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_rip_msg P((t_msg msg, void *arg1, void *arg2));
#endif
