/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_RIPINFO_H
#define LAY_RIPINFO_H	1

#include "layer.h"

typedef struct		s_ripinfo
{
  t_u16			family;
  t_u16			tag;
  t_32			dst;
  t_32			mask;
  t_32			router;
  t_32			metric;
} t_ripinfo;

#define RIPINFO_HLEN	(sizeof (t_ripinfo))

#define LAYER_RIPINFO_CHECK(ripinfopar,bufpar,lenpar) \
	if ((lenpar) < RIPINFO_HLEN)\
		return (-ERR_TRUNC);\
	(ripinfopar) = (t_ripinfo *)(bufpar);

extern t_assoc		family_assocs[];

/* PROTO lay_ripinfo.c */
/* lay_ripinfo.c */
t_status ripinfo_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_ripinfo_msg P((t_msg msg, void *arg1, void *arg2));
#endif
