/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_RPCCALL_H
#define LAY_RPCCALL_H	1

#include "layer.h"

typedef struct			s_rpccall
{
  t_u32				rpcversion;
  t_u32				program;
  t_u32				version;
  t_u32				procedure;
} t_rpccall;

#define RPCCALL_HLEN		(sizeof (t_rpccall))

#define LAYER_RPCCALL_CHECK(rpccallpar,bufpar,lenpar) \
	if ((lenpar) < RPCCALL_HLEN)\
		return (-ERR_TRUNC);\
	(rpccallpar) = (t_rpccall *)(bufpar);

#define RPCCALL_PORT		111

#define RPCCALLDIRECTION_CALL	0
#define RPCCALLDIRECTION_REPLY	1

/* PROTO lay_rpccall.c */
/* lay_rpccall.c */
t_status rpccall_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_rpccall_msg P((t_msg msg, void *arg1, void *arg2));
#endif
