/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_TCP_H
#define LAY_TCP_H	1

#include "layer.h"
#include "lay_ip.h"

typedef t_u32		t_tcp_seq;

typedef struct		s_tcp 
{
  t_u16			sport;
  t_u16			dport;
#define TCP_SEQACK_OFF		4
  t_tcp_seq		seq; 
  t_tcp_seq		ack; 
  t_u8			offx2;	
  t_u8			flags;
  t_u16			win;
  t_u16			sum;
  t_u16			urp;
} t_tcp;

#define TCP_MAXWIN	65535

#define TCP_MINHLEN	20
#define TCP_MAXHLEN	(15 * 4)

#define LAYER_TCP_CHECK(tcppar,bufpar,lenpar) \
	if ((lenpar) < TCP_MINHLEN)\
		return (-ERR_TRUNC);\
	(tcppar) = (t_tcp *)(bufpar);

#define TCP_FIN		0x01
#define TCP_SYN		0x02
#define TCP_RST		0x04
#define TCP_PUSH	0x08
#define TCP_ACK		0x10
#define TCP_URG		0x20

extern t_mask_def	tcpflags_mask_defs[];

/*
 * mba_ prefix means "must be aligned", i.e. mba_seq in tcp_get_seq().
 */

/* PROTO lay_tcp.c */
/* lay_tcp.c */
t_u16 tcp_cksum P((t_ip *ip));
void tcp_compute_sum P((t_ip *ip));
void tcp_set_proto P((t_ip *ip));
void tcp_set_sport P((t_tcp *tcp, int sport));
int tcp_get_sport P((t_tcp *tcp));
void tcp_set_dport P((t_tcp *tcp, int dport));
int tcp_get_dport P((t_tcp *tcp));
void tcp_set_seq P((t_tcp *tcp, t_tcp_seq seq));
t_tcp_seq tcp_get_seq P((t_tcp *tcp));
void tcp_set_ack P((t_tcp *tcp, t_tcp_seq ack));
t_tcp_seq tcp_get_ack P((t_tcp *tcp));
void tcp_set_off P((t_tcp *tcp, int off));
int tcp_get_off P((t_tcp *tcp));
void tcp_set_x2 P((t_tcp *tcp, int x2));
int tcp_get_x2 P((t_tcp *tcp));
void tcp_set_flags P((t_tcp *tcp, int flags));
int tcp_get_flags P((t_tcp *tcp));
void tcp_set_win P((t_tcp *tcp, int win));
int tcp_get_win P((t_tcp *tcp));
void tcp_set_sum P((t_tcp *tcp, int sum));
int tcp_get_sum P((t_tcp *tcp));
void tcp_set_urp P((t_tcp *tcp, int urp));
int tcp_get_urp P((t_tcp *tcp));
t_status tcp_off P((char *buf, int len, t_off *off));
t_status tcp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status tcp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status tcp_has_opt P((char *buf, int len, t_has_opt_data *hsd));
t_status lay_tcp_msg P((t_msg msg, void *arg1, void *arg2));
#endif
