/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_TRACERT_H
#define LAY_TRACERT_H	1

#include <sys/time.h>
#include "lay_ip.h"
#include "lay_udp.h"

typedef struct		s_tracert
{
  t_u8			seq;
  t_u8			ttl;
  struct timeval	tv;
} t_tracert;

#define TRACERT_HLEN	(sizeof (t_tracert))

#define TRACERT_MAGIC	(32768 + 666)

#define LAYER_TRACERT_CHECK(tracertpar,bufpar,lenpar) \
	if ((lenpar) < TRACERT_HLEN)\
		return (-ERR_TRUNC);\
	(tracertpar) = (t_tracert *)(bufpar);

/* PROTO lay_tracert.c */
/* lay_tracert.c */
t_status tracert_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_tracert_msg P((t_msg msg, void *arg1, void *arg2));
#endif
