/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAYER_H
#define LAYER_H	1

#include "a.h"

typedef struct		s_field
{
  char			*name;
  off_t			offset;
  t_msg_proc		mp;
  VOID_PTR		data;
} t_field;

#define NULL_FIELD	{NULL,0,NULL,NULL}

#include "lay_msg.h"
#include "typ_msg.h"

#ifdef DEBUG_MALLOC
# include "gdm.h"
# define LAYER_ALLOC_ALGORITHM	gdm_alloc_algorithm 
# define LAYER_ALLOC_PROC	gdm_alloc
# define LAYER_REALLOC_PROC	gdm_realloc
# define LAYER_FREE_PROC	gdm_free
#else
# define LAYER_ALLOC_ALGORITHM	alloc_algorithm_factor2
# define LAYER_ALLOC_PROC	alloc_malloc
# define LAYER_REALLOC_PROC	realloc_realloc
# define LAYER_FREE_PROC	free_free
#endif

#define LAYER_VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					LAYER_ALLOC_ALGORITHM,\
					LAYER_ALLOC_PROC,\
					LAYER_REALLOC_PROC,\
					LAYER_FREE_PROC,\
					"layer_vec",\
					(statusp))

#define LAYER_DICT_NEW(HashBase,VecBase,StatusPtr) dict_new((HashBase),\
								  (VecBase),\
						 dict_hash_code_public,\
						  LAYER_ALLOC_ALGORITHM,\
						  LAYER_ALLOC_PROC,\
						  LAYER_REALLOC_PROC,\
						  LAYER_FREE_PROC,\
								"layer_dict",\
								  (StatusPtr))

#define LAYER_ID_NEW(statusp)	id_new(HASH_BASE,\
				       VEC_BASE,\
				       LAYER_ALLOC_ALGORITHM,\
				       LAYER_ALLOC_PROC,\
				       LAYER_REALLOC_PROC,\
				       LAYER_FREE_PROC,\
				       "layer_id",\
				       (statusp))

#define LAYER_TINY_ID_NEW(statusp)	id_new(HASH_TINY_BASE,\
					       VEC_BASE,\
					       LAYER_ALLOC_ALGORITHM,\
					       LAYER_ALLOC_PROC,\
					       LAYER_REALLOC_PROC,\
					       LAYER_FREE_PROC,\
					       "layer_small_id",\
					       (statusp))

extern t_32			layer_resolve;
extern t_32			layer_base;
extern t_32			layer_verb_level;
extern t_mask_def		layer_verb_level_mask_defs[];

#ifdef DEBUG
# define VERB_LAY_MSG		(1L<<0)
# define VERB_TYP_MSG		(1L<<1)
# define VERB_LAYER_INIT	(1L<<2)
# define VERB_MISCINET		(1L<<3)
# define VERB_XMIT_MSG		(1L<<4)
# define VERB_PKT_SAV		(1L<<5)

# define LAYER_VERB(level)	((layer_verb_level != 0L)?\
				 (level) & layer_verb_level:FALSE) 
#endif

/* PROTO layer.c */
/* layer.c */
t_status layer_init P((void));
void layer_destroy P((void));
void layer_debug_init P((void));
#endif
