/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef PKT_SAV_H
#define PKT_SAV_H	1

#include "pkt.h"

#define PKT_SAV_COOKIE	"PKT"

/* 
 * Pkt file format is:
 * PKT_SAV_COOKIE \n
 * Layer \n
 * Len \n
 * Netlen \n
 * Timestamp in timeval format (%d.%d) \n
 * Data in hexadecimal (8 couples of 2 hex digits per line)
 *
 * Example, an icmp packet starting from a ip header:
 * PKT
 * ip
 * 84
 * 84
 * 0.0
 * 4500 0054 ffff 0000 ff01 ffff ffff ffff
 * ffff ffff 0800 dd03 0159 0000 34a5 4fbe
 * 000c aa30 0809 0a0b 0c0d 0e0f 1011 1213
 * 1415 1617 1819 1a1b 1c1d 1e1f 2021 2223
 * 2425 2627 2829 2a2b 2c2d 2e2f 3031 3233
 * 3435 3637
 */

/* PROTO pkt_sav.c */
/* pkt_sav.c */
t_status pkt_save P((t_pkt *pkt, char *fname));
t_vec *pkt_load_to_vec P((char *fname, t_status *status));
t_status pkt_load P((t_pkt *pkt, char *fname, t_alloc_proc alloc_proc, t_free_proc free_proc));
#endif
