/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef TYP_MSG_H
#define TYP_MSG_H	1

#include "a.h"

typedef struct		s_extract_data
{
  t_buf			b;
  VOID_PTR		data;
} t_extract_data;

typedef struct		s_bit_field_assocs_data
{
  t_bit_field		*bit_field;
  t_assoc		*assocs;
} t_bit_field_assocs_data;

#define TYP_CLASS_GENERIC	\
case MSG_CLASS:\
{\
  MSG_CLASS_ARGS(unused,classbs);\
  \
    return (str_cat_str(classbs->str,\
		      classbs->max_len,\
		      "typ"));\
}

#define TYP_NAME			2
#define TYP_NAME_ARGS(Unused,BridledStr)	\
	ARG2(t_bridled_str *,BridledStr)

#define TYP_NAME_GENERIC(Name) \
case TYP_NAME:\
{\
   TYP_NAME_ARGS(unused,bs);\
\
   return (str_cat_str(bs->str,\
		       bs->max_len,\
		       (Name)));\
}

#define TYP_EXTRACT			3
#define TYP_EXTRACT_ARGS(ExtractData,BridledStr)	\
     ARG1(t_extract_data *,ExtractData);\
     ARG2(t_bridled_str *,BridledStr)

#define TYP_INSERT			4
#define TYP_INSERT_ARGS(ExtractData,Value)	\
     ARG1(t_extract_data *,ExtractData);\
     ARG2(char *,Value)

#define TYP_GET_CHOICES			5
#define TYP_GET_CHOICES_ARGS(ExtractData,VecStr) \
     ARG1(t_extract_data *,ExtractData);\
     ARG2(t_vec *,VecStr)

#define TYP_OFF				6
#define TYP_OFF_ARGS(ExtractData,OffPtr) \
     ARG1(t_extract_data *,ExtractData);\
     ARG2(t_off *,OffPtr)

/* PROTO typ_msg.c */
/* typ_msg.c */
t_status typ_msg P((t_msg_proc mp, t_msg msg, void *arg1, void *arg2));
#endif
