/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef TYP_SUBNET_H
#define TYP_SUBNET_H	1

#include "a.h"

/* PSEUDO TYPE FOR MISC USAGES */

typedef struct		s_subnet
{
  struct in_addr	addr;
  struct in_addr	mask;
  struct in_addr	cable;	
  struct in_addr	broadcast;
} t_subnet;

#define SUBNET_ADDR		0
#define SUBNET_CABLE		1
#define SUBNET_BROADCAST	2

#define SUBNET_STYLE_PREFIX	0
#define SUBNET_STYLE_NETMASK	1

typedef t_status	(*t_subnet_walk_proc) P((struct in_addr *ip_addr,
						 int flag,
						 VOID_PTR data));

/* PROTO typ_subnet.c */
/* typ_subnet.c */
int in_class_default_nshift P((struct in_addr *addr));
t_status subnet_from_str P((char *str, t_subnet *subnet));
int prefix_from_netmask P((struct in_addr *netmask));
t_status subnet_to_str P((t_subnet *subnet, char *str, int max_len, int style));
t_boolean is_subnet_member P((struct in_addr *inaddr, t_subnet *subnet));
t_status subnet_walk P((t_subnet *subnet, t_subnet_walk_proc proc, void *data));
t_status vec_prefixes_from_vec_str P((t_vec *vec_pref, t_vec *vec_str));
void subnet_show P((t_subnet *subnet));
t_status typ_subnet_msg P((t_msg msg, void *arg1, void *arg2));
#endif
