/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_arp.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_arpethip.h"
#include "lay_data.h"
#include "typ_16.h"
#include "typ_8.h"
#include "lay_ether.h"

t_assoc		arphrd_assocs[] = 
{
  {"ether",	(VOID_PTR)ARPHRD_ETHER},
  {"802",	(VOID_PTR)ARPHRD_802},
  NULL_ASSOC
};

t_assoc		arpop_assocs[] = 
{
  {"request",	(VOID_PTR)ARPOP_REQUEST},
  {"reply",	(VOID_PTR)ARPOP_REPLY},
  NULL_ASSOC
};

VOID_FUNC	arp_set_hrd(arp,hrd)
t_arp		*arp;
int		hrd;
{
  safe_htons(hrd,(&arp->hrd));
}

int		arp_get_hrd(arp)
t_arp		*arp;
{
  return (safe_ntohs(&(arp->hrd)));
}

VOID_FUNC	arp_set_pro(arp,pro)
t_arp		*arp;
int		pro;
{
  safe_htons(pro,&(arp->pro));
}

int		arp_get_pro(arp)
t_arp		*arp;
{
  return (safe_ntohs(&(arp->pro)));
}

VOID_FUNC	arp_set_hln(arp,hln)
t_arp		*arp;
int		hln;
{
  arp->hln = hln;
}

int		arp_get_hln(arp)
t_arp		*arp;
{
  return (arp->hln);
}

VOID_FUNC	arp_set_pln(arp,pln)
t_arp		*arp;
int		pln;
{
  arp->pln = pln;
}

int		arp_get_pln(arp)
t_arp		*arp;
{
  return (arp->pln);
}

VOID_FUNC	arp_set_op(arp,op)
t_arp		*arp;
int		op;
{
  safe_htons(op,&(arp->op));
}

int		arp_get_op(arp)
t_arp		*arp;
{
  return (safe_ntohs(&(arp->op)));
}

t_status	arp_sub(buf,len,sub_mp)
char		*buf;
int		len;
t_msg_proc	*sub_mp;
{
  t_arp	*arp;

  LAYER_ARP_CHECK(arp,buf,len);
  if (arp_get_hrd(arp) == ARPHRD_ETHER &&
      arp_get_pro(arp) == ETHERTYPE_IP)
    {
      (*sub_mp) = &lay_arpethip_msg;
      return (0);
    }
  else
    {
      (*sub_mp) = &lay_data_msg;
      return (0);
    }
}

t_field				arp_fields[] = 
{
  {"hrd",	OFFSET(t_arp *,hrd),	typ_nu16_msg,		NULL},
  {"Hrd",	OFFSET(t_arp *,hrd),	typ_nu16assoc_msg,	arphrd_assocs},
  {"pro",	OFFSET(t_arp *,pro),	typ_nu16_msg,		NULL},
  {"Pro",	OFFSET(t_arp *,pro),	typ_nu16assoc_msg,   ethertype_assocs},
  {"hln",	OFFSET(t_arp *,hln),	typ_u8_msg,		NULL},
  {"pln",	OFFSET(t_arp *,pln),	typ_u8_msg,		NULL},
  {"op",	OFFSET(t_arp *,op),	typ_nu16_msg,		NULL},
  {"Op",	OFFSET(t_arp *,op),	typ_nu16assoc_msg,    arpop_assocs},
  NULL_FIELD
};

char				*arp_itmpl = "\n\
<!--arp_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%arpColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(arp[%i%])\">[Extract]</a>\n\
<a href=\"trunc(arp[%i%])\">[Trunc]</a>\n\
<a href=\"paste(arp[%i%])\">[Paste]</a>\n\
 arp\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%><a href=\"setfield(arp[%i%].Hrd)\">%%arp[%i%].Hrd%%</a>(<a href=\"setfield(arp[%i%].hrd)\">%%arp[%i%].hrd%%</a>)</td>\n\
<td align=center width=50%%%%><a href=\"setfield(arp[%i%].Pro)\">%%arp[%i%].Pro%%</a>(<a href=\"setfield(arp[%i%].pro)\">%%arp[%i%].pro%%</a>)</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=25%%%%><a href=\"setfield(arp[%i%].hln)\">%%arp[%i%].hln%%</a></td>\n\
<td align=center width=25%%%%><a href=\"setfield(arp[%i%].pln)\">%%arp[%i%].pln%%</a></td>\n\
<td align=center width=50%%%%><a href=\"setfield(arp[%i%].Op)\">%%arp[%i%].Op%%</a>(<a href=\"setfield(arp[%i%].op)\">%%arp[%i%].op%%</a>)</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_arp_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
    case MSG_CLASS:
      {
	MSG_CLASS_ARGS(unused,bs);
	
	return (lay_class_generic(bs));
      }
    case LAY_NAME:
      {
	LAY_NAME_ARGS(optional_id,bs);

	return (lay_name_id_generic(optional_id,
				    bs,
				    &lay_arp_msg,
				    "arp"));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);

	return (lay_get_field_generic(gfd,
				      bs,
				      arp_fields));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);

	return (lay_set_field_generic(gfd,
				      str,
				      arp_fields));
      }
    case LAY_GET_FIELDS:
      {
	LAY_GET_FIELDS_ARGS(b,vec);

	return (lay_get_fields_generic(b,
				       vec,
				       arp_fields));
      }
    case LAY_GET_TMPL:
      {
	LAY_GET_TMPL_ARGS(gtd,bs);

	return (lay_get_itmpl_generic(gtd,
				      bs,
				      &lay_arp_msg,
				      arp_itmpl));
      }
    case LAY_GET_FIELD_TYP:
      {
	LAY_GET_FIELD_TYP_ARGS(gfd,gftd);

	return (lay_get_field_typ_generic(gfd,
					  gftd,
					  arp_fields));
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = ARP_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (arp_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
