/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "lay_arpethip.h"
#include "lay_ether.h"
#include "lay_ip.h"
#include "typ_inaddr.h"
#include "typ_ethaddr.h"
#include "typ_mac.h"
#include "lay_data.h"

VOID_FUNC		arpethip_set_sha(aei,mba_sha)
t_arpethip		*aei;	
t_ether_addr		*mba_sha;
{
  FBCOPY(mba_sha,&(aei->sha),sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_get_sha(aei,mba_sha)
t_arpethip		*aei;
t_ether_addr		*mba_sha;
{
  FBCOPY(&(aei->sha),mba_sha,sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_set_tha(aei,mba_tha)
t_arpethip		*aei;	
t_ether_addr		*mba_tha;
{
  FBCOPY(mba_tha,&(aei->tha),sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_get_tha(aei,mba_tha)
t_arpethip		*aei;
t_ether_addr		*mba_tha;
{
  FBCOPY(&(aei->tha),mba_tha,sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_set_tpa(aei,mba_tpa)
t_arpethip		*aei;	
t_in_addr		*mba_tpa;
{
  FBCOPY(mba_tpa,&(aei->tpa),sizeof (struct in_addr));
}

VOID_FUNC		arpethip_get_tpa(aei,mba_tpa)
t_arpethip		*aei;
t_in_addr		*mba_tpa;
{
  FBCOPY(&(aei->tpa),mba_tpa,sizeof (struct in_addr));
}

VOID_FUNC		arpethip_set_spa(aei,mba_spa)
t_arpethip		*aei;	
t_in_addr		*mba_spa;
{
  FBCOPY(mba_spa,&(aei->spa),sizeof (struct in_addr));
}

VOID_FUNC		arpethip_get_spa(aei,mba_spa)
t_arpethip		*aei;
t_in_addr		*mba_spa;
{
  FBCOPY(&(aei->spa),mba_spa,sizeof (struct in_addr));
}

t_field				arpethip_fields[] = 
{
  {"sha",	OFFSET(t_arpethip *,sha),typ_etheraddr_msg,		NULL},
  {"Sha",	OFFSET(t_arpethip *,sha),typ_mac_msg,			NULL},
  {"spa",	OFFSET(t_arpethip *,spa),typ_inaddr_msg,		NULL},
  {"Spa",	OFFSET(t_arpethip *,spa),typ_inaddr_resolved_msg,	NULL},
  {"tha",	OFFSET(t_arpethip *,tha),typ_etheraddr_msg,		NULL},
  {"Tha",	OFFSET(t_arpethip *,tha),typ_mac_msg,			NULL},
  {"tpa",	OFFSET(t_arpethip *,tpa),typ_inaddr_msg,		NULL},
  {"Tpa",	OFFSET(t_arpethip *,tpa),typ_inaddr_resolved_msg,	NULL},
  NULL_FIELD
};

char				*arpethip_itmpl = "\n\
<!--arpethip_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%arpethipColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(arpethip[%i%])\">[Extract]</a>\n\
<a href=\"trunc(arpethip[%i%])\">[Trunc]</a>\n\
<a href=\"paste(arpethip[%i%])\">[Paste]</a>\n\
 arpethip\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(arpethip[%i%].sha)\">%%arpethip[%i%].sha%%</a>\n\
<_tiny>\n\
<a href=\"setfield(arpethip[%i%].Sha)\">%%arpethip[%i%].Sha%%</a>\n\
</_tiny>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(arpethip[%i%].Spa)\">%%arpethip[%i%].Spa%%</a>\n\
(<a href=\"setfield(arpethip[%i%].spa)\">%%arpethip[%i%].spa%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(arpethip[%i%].tha)\">%%arpethip[%i%].tha%%</a>\n\
<_tiny>\n\
<a href=\"setfield(arpethip[%i%].Tha)\">%%arpethip[%i%].Tha%%</a>\n\
</_tiny>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(arpethip[%i%].Tpa)\">%%arpethip[%i%].Tpa%%</a>\n\
(<a href=\"setfield(arpethip[%i%].tpa)\">%%arpethip[%i%].tpa%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_arpethip_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_arpethip_msg,"arpethip");
      LAY_GET_FIELD_GENERIC(arpethip_fields);
      LAY_SET_FIELD_GENERIC(arpethip_fields);
      LAY_GET_FIELDS_GENERIC(arpethip_fields);
      LAY_GET_FIELD_TYP_GENERIC(arpethip_fields);
      LAY_GET_ITMPL_GENERIC(&lay_arpethip_msg,arpethip_itmpl);
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);

	(*mp) = lay_data_msg;
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = ARPETHIP_HLEN;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
