/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "layer.h"
#include "typ_lay.h"
#include "pkt.h"
#include "lay_ether.h"
#include "lay_ip.h"
#include "lay_data.h"
#include "lay_guess.h"

t_status			lay_pkt_guess(buf,len,mp)
char				*buf;
int				len;
t_msg_proc			*mp;
{
  if (len >= ETHER_HLEN)
    {
      if (ether_sub(buf,len,mp) == 0)
	{
	  if ((*mp) != lay_data_msg)
	    return (0);
	}
    }
  if (len >= IP_MINHLEN)
    {
      t_ip		     *ip;

      ip = (t_ip *)buf;
      if (ip_get_v(ip) == 4 && ip_get_hl(ip) == 5)
        {
          (*mp) = lay_ip_msg;
          return (0);
        }
    }
  (*mp) = lay_data_msg;
  return (0);
}
