/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include "lay_rpc.h"
#include "lay_data.h"
#include "lay_rpccall.h"
#include "typ_32.h"

t_assoc				rpcdirection_assocs[] =
{
  {"call",			(VOID_PTR)RPCDIRECTION_CALL},
  {"reply",			(VOID_PTR)RPCDIRECTION_REPLY},
  {NULL,			NULL},
};

t_status			rpc_sub(buf,len,sub_mp)
char				*buf;
int				len;
t_msg_proc			*sub_mp;
{
  t_rpc				*rpc;
  t_u32				direction;

  LAYER_RPC_CHECK(rpc,buf,len);
  direction = safe_ntohl(&(rpc->direction));
  switch (direction)
    {
    case RPCDIRECTION_CALL:
      (*sub_mp) = &lay_rpccall_msg;
      return (0);
    }
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				rpc_fields[] = 
{
  {"xid",	OFFSET(t_rpc *,xid),	typ_nu32_msg,	NULL},
  {"direction",OFFSET(t_rpc *,direction),typ_nu32_msg,	NULL},
  {"Direction",OFFSET(t_rpc *,direction),typ_nu32assoc_msg,
   rpcdirection_assocs},
  NULL_FIELD
};

char				*rpc_itmpl = "\n\
<!--rpc_itmpl-->\n\
<table width=100%%%% cellpadding=3 bgcolor=\"%%rpcColor%%\">\n\
<tr>\n\
<td width=100%%%% colspan=3>\n\
<small>\n\
<a href=\"extract(rpc[%i%])\">[Extract]</a>\n\
<a href=\"trunc(rpc[%i%])\">[Trunc]</a>\n\
<a href=\"paste(rpc[%i%])\">[Paste]</a>\n\
 rpc\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(rpc[%i%].xid)\">%%rpc[%i%].xid%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(rpc[%i%].Direction)\">%%rpc[%i%].Direction%%</a>\n\
(<a href=\"setfield(rpc[%i%].direction)\">%%rpc[%i%].direction%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_rpc_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_rpc_msg,"rpc");
      LAY_GET_FIELD_GENERIC(rpc_fields);
      LAY_SET_FIELD_GENERIC(rpc_fields);
      LAY_GET_FIELDS_GENERIC(rpc_fields);
      LAY_GET_FIELD_TYP_GENERIC(rpc_fields);
      LAY_GET_ITMPL_GENERIC(&lay_rpc_msg,rpc_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = RPC_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (rpc_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
