/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_tcpopt.h"
#include "typ_8.h"
#include "typ_16.h"
#include "typ_32.h"
#include "typ_time.h"

/*
Kind   Length   Meaning                           Reference
----   ------   -------------------------------   ---------
  0        -    End of Option List                 [RFC793]
  1        -    No-Operation                       [RFC793]
  2        4    Maximum Segment Lifetime           [RFC793]
  3        3    WSOPT - Window Scale              [RFC1323]
  4        2    SACK Permitted                    [RFC1072]
  5        N    SACK                              [RFC1072]
  6        6    Echo (obsoleted by option 8)      [RFC1072]
  7        6    Echo Reply (obsoleted by option 8)[RFC1072]
  8       10    TSOPT - Time Stamp Option         [RFC1323]
  9        2    Partial Order Connection Permitted[RFC1693]
 10        5    Partial Order Service Profile     [RFC1693]
 11             CC                                 [Braden]
 12             CC.NEW                             [Braden]
 13             CC.ECHO                            [Braden]
 14         3   TCP Alternate Checksum Request    [RFC1146]
 15         N   TCP Alternate Checksum Data       [RFC1146]
 16             Skeeter                           [Knowles]
 17             Bubba                             [Knowles]
 18         3   Trailer Checksum Option    [Subbu & Monroe]


TCP ALTERNATE CHECKSUM NUMBERS


Number  Description                     Reference
------- ------------------------------- ----------
   0    TCP Checksum                    [RFC-1146]
   1    8-bit Fletchers's algorithm     [RFC-1146]
   2    16-bit Fletchers's algorithm    [RFC-1146]
   3    Redundant Checksum Avoidance    [Kay]
*/

t_assoc				tcpopt_assocs[] = 
{
  {"eool",			(VOID_PTR)TCPOPT_EOOL},
  {"nop",			(VOID_PTR)TCPOPT_NOP},
  {"mss",			(VOID_PTR)TCPOPT_MSS},
  {"win",			(VOID_PTR)TCPOPT_WIN},
  {"ts",			(VOID_PTR)TCPOPT_TS},
  {NULL,			0},
};

t_field				tcpopt_simple_fields[] = 
{
  {"kind",	0,	typ_u8_msg,		NULL},
  {"Kind",	0,	typ_u8assoc_msg,	(VOID_PTR)tcpopt_assocs},
  NULL_FIELD
};

t_field				tcpopt_double_fields[] = 
{
  {"kind",	0,	typ_u8_msg,		NULL},
  {"Kind",	0,	typ_u8assoc_msg,	(VOID_PTR)tcpopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  NULL_FIELD
};

t_field				tcpopt_mss_fields[] = 
{
  {"kind",	0,	typ_u8_msg,		NULL},
  {"Kind",	0,	typ_u8assoc_msg,	(VOID_PTR)tcpopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  {"mss",	2,	typ_nu16_msg,		NULL},
  NULL_FIELD
};

t_field				tcpopt_win_fields[] = 
{
  {"kind",	0,	typ_u8_msg,		NULL},
  {"Kind",	0,	typ_u8assoc_msg,	(VOID_PTR)tcpopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  {"shift",	2,	typ_u8_msg,		NULL},
  NULL_FIELD
};

t_field				tcpopt_ts_fields[] = 
{
  {"kind",	0,	typ_u8_msg,		NULL},
  {"Kind",	0,	typ_u8assoc_msg,	(VOID_PTR)tcpopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  {"ts",	2,	typ_nu32_msg,		NULL},
  {"Ts",	2,	typ_time_msg,		NULL},
  {"tsreply",	6,	typ_nu32_msg,		NULL},
  {"Tsreply",	6,	typ_time_msg,		NULL},
  NULL_FIELD
};

t_field			*tcpopt_get_fields(buf,len,status)
char			*buf;
int			len;
t_status		*status;
{
  if (len < 1)
    {
      *status = -ERR_TRUNC;
      return (NULL);
    }
  switch ((t_u8)(buf[0]))
    {
    case TCPOPT_EOOL:
    case TCPOPT_NOP:
      return (tcpopt_simple_fields);
    case TCPOPT_MSS:
      return (tcpopt_mss_fields);
    case TCPOPT_WIN:
      return (tcpopt_win_fields);
    case TCPOPT_TS:
      return (tcpopt_ts_fields);
    default:
      return (tcpopt_double_fields);
    }
}

char				*tcpopt_simple_itmpl = "\n\
<!--tcpopt_simple_itmpl-->\n\
<table bgcolor=\"%%tcpoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(tcpopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tcpopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tcpopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(tcpopt[%i%])\">[Adapt len]</a>\n\
 tcpopt_simple\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Kind)\">%%tcpopt[%i%].Kind%%</a>\n\
(<a href=\"setfield(tcpopt[%i%].kind)\">%%tcpopt[%i%].kind%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*tcpopt_double_itmpl = "\n\
<!--tcpopt_double_itmpl-->\n\
<table bgcolor=\"%%tcpoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(tcpopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tcpopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tcpopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(tcpopt[%i%])\">[Adapt len]</a>\n\
 tcpopt_double\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Kind)\">%%tcpopt[%i%].Kind%%</a>\n\
(<a href=\"setfield(tcpopt[%i%].kind)\">%%tcpopt[%i%].kind%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].len)\">%%tcpopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*tcpopt_mss_itmpl = "\n\
<!--tcpopt_mss_itmpl-->\n\
<table bgcolor=\"%%tcpoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(tcpopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tcpopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tcpopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(tcpopt[%i%])\">[Adapt len]</a>\n\
 tcpopt_mss\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Kind)\">%%tcpopt[%i%].Kind%%</a>\n\
(<a href=\"setfield(tcpopt[%i%].kind)\">%%tcpopt[%i%].kind%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].len)\">%%tcpopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].mss)\">%%tcpopt[%i%].mss%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*tcpopt_win_itmpl = "\n\
<!--tcpopt_win_itmpl-->\n\
<table bgcolor=\"%%tcpoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(tcpopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tcpopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tcpopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(tcpopt[%i%])\">[Adapt len]</a>\n\
 tcpopt_win\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Kind)\">%%tcpopt[%i%].Kind%%</a>\n\
(<a href=\"setfield(tcpopt[%i%].kind)\">%%tcpopt[%i%].kind%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].len)\">%%tcpopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].shift)\">%%tcpopt[%i%].shift%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*tcpopt_ts_itmpl = "\n\
<!--tcpopt_ts_itmpl-->\n\
<table bgcolor=\"%%tcpoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(tcpopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tcpopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tcpopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(tcpopt[%i%])\">[Adapt len]</a>\n\
 tcpopt_ts\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Kind)\">%%tcpopt[%i%].Kind%%</a>\n\
(<a href=\"setfield(tcpopt[%i%].kind)\">%%tcpopt[%i%].kind%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].len)\">%%tcpopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Ts)\">%%tcpopt[%i%].Ts%%</a>(<a href=\"setfield(tcpopt[%i%].ts)\">%%tcpopt[%i%].ts%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(tcpopt[%i%].Tsreply)\">%%tcpopt[%i%].Tsreply%%</a>\n\
(<a href=\"setfield(tcpopt[%i%].tsreply)\">%%tcpopt[%i%].tsreply%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char			*tcpopt_get_itmpl(buf,len,status)
char			*buf;
int			len;
t_status		*status;
{
  if (len < 1)
    {
      *status = -ERR_TRUNC;
      return (NULL);
    }
  switch ((t_u8)(buf[0]))
    {
    case TCPOPT_EOOL:
    case TCPOPT_NOP:
      return (tcpopt_simple_itmpl);
    case TCPOPT_MSS:
      return (tcpopt_mss_itmpl);
    case TCPOPT_WIN:
      return (tcpopt_win_itmpl);
    case TCPOPT_TS:
      return (tcpopt_ts_itmpl);
    default:
      return (tcpopt_double_itmpl);
    }
}

t_status		tcpopt_has_opt(buf,len,hsd)
char			*buf;
int			len;
t_has_opt_data		*hsd;
{
  if (len < 1)
    return (-ERR_TRUNC);
  hsd->has_opt = FALSE;
  return (0);
}

char				*tcpoptdata_itmpl = "\n\
<!--tcpoptdata_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%tcpoptColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tcpoptdata[%i%])\">[Extract]</a>\n\
<a href=\"paste(tcpoptdata[%i%])\">[Paste]</a>\n\
 tcpoptdata %%tcpoptdata[%i%].len%% byte(s)\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td width=100%%%%>\n\
<code>\n\
%%tcpoptdata[%i%].cookedhtmlbuf%%\n\
</code>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tcpoptdata_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;	
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tcpoptdata_msg,"tcpoptdata");
      LAY_GET_ITMPL_GENERIC(&lay_tcpoptdata_msg,tcpoptdata_itmpl);
    }
  return (lay_data_msg(msg,arg1,arg2));
}

t_status			lay_tcpopt_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tcpopt_msg,"tcpopt");
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);

	if (b->len < 1)
	  return (-ERR_TRUNC);
	switch ((t_u8)(b->buf[0]))
	  {
	  case TCPOPT_EOOL:
	  case TCPOPT_NOP:
	    (*off) = 1;
	    return (0);
	  }
	if (b->len < 2)
	  return (-ERR_TRUNC);
	(*off) = (t_off)(t_u8)(b->buf[1]);
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,sub_mp);
		
	if (b->len < 1)
	  return (-ERR_TRUNC);
	switch ((t_u8)(b->buf[0]))
	  {
	  case TCPOPT_EOOL:
	    (*sub_mp) = &lay_tcpoptdata_msg;
	    return (0);
	  }
	(*sub_mp) = &lay_tcpopt_msg;
	return (0);
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	t_field			*fields;
	t_field			*field;
	
	if ((fields = tcpopt_get_fields(gfd->b.buf,
				       gfd->b.len,
				       &status)) == NULL)
	  return (status);
	field = NULL;
	while (fields->name)
	  {
	    if (!strcmp(fields->name,gfd->field))
	      field = fields;
	    fields++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	t_field			*fields;
	t_field			*field;
	
	if ((fields = tcpopt_get_fields(gfd->b.buf,
				       gfd->b.len,
				       &status)) == NULL)
	  return (status);
	field = NULL;
	while (fields->name)
	  {
	    if (!strcmp(fields->name,gfd->field))
	      field = fields;
	    fields++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    case LAY_GET_FIELD_TYP:
      {
	LAY_GET_FIELD_TYP_ARGS(gfd,gftd);
	t_field			*fields;	

	if ((fields = tcpopt_get_fields(gfd->b.buf,
				       gfd->b.len,
				       &status)) == NULL)
	  return (status);
	while (fields->name)
	  {
	    if (!strcmp(gfd->field,fields->name))
	      {
		gftd->mp = fields->mp;
		gftd->data = fields->data;
		return (0);
	      }
	    fields++;
	  }
	return (-ERR_NOENT);
      }
    case LAY_GET_TMPL:
      {
	LAY_GET_TMPL_ARGS(gtd,bs);
	char		*itmpl;
	t_hash_elt	*he;
	int		i;

	if ((itmpl = tcpopt_get_itmpl(gtd->b.buf,
				   gtd->b.len,
				   &status)) == NULL)
	  return (status);
	if (he = id_get(gtd->id,
			&lay_tcpopt_msg))
	  i = (int)(he->value);
	else
	  i = 0;
	if ((status = itmpl_format(i,
				   itmpl,
				   bs->str,
				   bs->max_len)) < 0)
	  return (status);
	if ((status = id_override(gtd->id,
				  &lay_tcpopt_msg,
				  (VOID_PTR)(++i))) < 0)
	  return (status);
	return (0);
      }
    case LAY_HAS_OPT:
      {
	LAY_HAS_OPT_ARGS(b,hsd);
	
	return (tcpopt_has_opt(b->buf,b->len,hsd));
      }
    }
  return (-ERR_NOMETHOD);
}
