/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "typ_msg.h"
#include "typ_buf.h"

/* is a t_msg_proc.
   Manages fixed buffers. Len must be encoded in ed->data. */
t_status		typ_buf_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("buf");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u16		len;
	int		ulen;

	ulen = (int)(ed->data);
	if (ed->b.len < ulen)
	  return (-ERR_TRUNC);
	return (buf_to_xdata_str(ed->b.buf,
				 ulen,
				 65535 + 1, /* INFINITY */
				 "",
				 " ",
				 bs->str,
				 bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_status	status;	
	int		ilen;
	char		buf[BUFSIZ];
	t_u16		len;

	if ((status = xdata_to_buf(str,
				   buf,
				   &ilen,
				   sizeof (buf))) < 0)
	  return (status);
	if (ed->b.len < ilen)
	  return (-ERR_TRUNC);
	bcopy(buf,ed->b.buf,ilen);
	return (0);
      }
    case TYP_OFF:
      {
	TYP_OFF_ARGS(ed,off);
	
	(*off) = (t_off)(ed->data);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
