/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "typ_msg.h"
#include "typ_dnsqname.h"

/* is a t_msg_proc.
   Manages memory zones in the form of |len (one byte)|c1|c2|...|clen| as
   used mainly in dns query names. It can encode strings from a length of
   zero up to 255 theorically. It isn't the case because of dns query
   name compression but it is handled by the layer itself. */
t_status		typ_dnsqname_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("dnsqname");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	int		len;

	if (ed->b.len < 1)
	  return (-ERR_TRUNC);
	len = (t_u32)(t_u8)(ed->b.buf[0]);
	if (ed->b.len < (1 + len))
	  return (-ERR_TRUNC);
	return (str_cat_buf(bs->str,
			    bs->max_len,
			    ed->b.buf + 1,
			    len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_status	status;	
	int		len;

	if ((len = strlen(str)) > 255)
	  return (-ERR_TOOBIG);
	if (ed->b.len < (len + 1))
	  return (-ERR_TRUNC);
	ed->b.buf[0] = (t_u8)len;
	bcopy(str,ed->b.buf + 1,len);
	return (0);
      }
    case TYP_OFF:
      {
	TYP_OFF_ARGS(ed,off);
	int		len;

	if (ed->b.len < 1)
	  return (-ERR_TRUNC);
	len = (t_u32)(t_u8)(ed->b.buf[0]);
	(*off) = (t_off)len + 1;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
