/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "lay_ether.h"
#include "typ_msg.h"
#include "typ_ethaddr.h"

t_boolean			etheraddr_dec_way = FALSE;

t_status			etheraddr_from_str(ea,str)
t_ether_addr			*ea;
char				*str;
{
  int				nmatch;
  unsigned int			o[6];
  int				i;
  unsigned int			pat;
  t_boolean			badpat;

  nmatch = 0;
  if (index(str,'-'))
    nmatch = sscanf(str,"%x-%x-%x-%x-%x-%x",
		    &(o[0]),&(o[1]),&(o[2]),&(o[3]),&(o[4]),&(o[5]));
  else
    if (index(str,':'))
      nmatch = sscanf(str,"%x:%x:%x:%x:%x:%x",
		      &(o[0]),&(o[1]),&(o[2]),&(o[3]),&(o[4]),&(o[5]));
  if (nmatch != sizeof (t_ether_addr))
    return (-ERR_BADFMT);
  badpat = TRUE;
  pat = o[0];
  i = 0;
  while (i < sizeof (t_ether_addr))
    {
      if (o[i] != pat)
	badpat = FALSE;
      ea->o[i] = o[i];
      i++;
    }
  if (badpat && pat != 0xff && pat != 0x00)
    return (-ERR_BADADDR);
  return (0);
}

t_status			etheraddr_to_str(ea,str,max_len)
t_ether_addr			*ea;
char				*str;
int				max_len;
{
  unsigned char			o[6];
  int				i;
  t_status			status;
  int				c;

  i = 0;
  while (i < sizeof (t_ether_addr))
    {
      o[i] = ea->o[i];
      i++;
    }
  if (etheraddr_dec_way)
    c = '-';
  else
    c = ':';
  return (str_cat_fmt_va(str,max_len,
			 "%02x%c%02x%c%02x%c%02x%c%02x%c%02x",
			 (unsigned char)o[0],
			 c,
			 (unsigned char)o[1],
			 c,
			 (unsigned char)o[2],
			 c,
			 (unsigned char)o[3],
			 c,
			 (unsigned char)o[4],
			 c,
			 (unsigned char)o[5]));
}

char			*typ_etheraddr_ntoa(ea)
t_ether_addr		*ea;
{
  static char		buf[STR_BUFSIZ]; /* ITS ENOUGH */
  t_status		status;	
  
  buf[0] = 0;
  status = etheraddr_to_str(ea,buf,sizeof (buf));
  assert(status == 0);
  return (buf);
}

/* is a t_msg_proc.
   It manages ethernet addresses. It undestands the syntax x:x:x:x:x:x or
   x-x-x-x-x-x (DEC way). */
t_status		typ_etheraddr_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("etheraddr");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_ether_addr	etheraddr;

	if (ed->b.len < sizeof (etheraddr))
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&etheraddr,sizeof (etheraddr));
	return (etheraddr_to_str(&etheraddr,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_ether_addr	etheraddr;
	t_status	status;	

	if (ed->b.len < sizeof (etheraddr))
	  return (-ERR_TRUNC);
	if ((status = etheraddr_from_str(&etheraddr,str)) < 0)
	  return (status);
	FBCOPY(&etheraddr,ed->b.buf,sizeof (t_ether_addr));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
