/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "typ_msg.h"

char			*typ_msg_list[] =
{
  "Message 0",					/* 0	*/
  "Get class",					/* 1	*/
  "Name yourself",				/* 2	*/
  "Extract",					/* 3	*/
  "Insert",					/* 4	*/
  "Get choices",				/* 5	*/
  "Get offset",					/* 6	*/
}; 

#define DEBUG_OFF	1
#define DEBUG_INSERT	1
#define DEBUG_EXTRACT	1

/* calls a method of a "typ" msg_proc.
   If verbose mode is "typ_msg" then it prints all the calls and parameters
   of methods. 
   Returns the method result */
t_status			typ_msg(mp,msg,arg1,arg2)
t_msg_proc			mp;
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
#ifdef DEBUG
  if (LAYER_VERB(VERB_TYP_MSG))
    {
      t_status			status;
      char			name[STR_BUFSIZ];
      t_bridled_str		namebs;
      int			len;
      
      namebs.str = name;
      namebs.max_len = sizeof (name);
      name[0] = 0;
      status = mp(TYP_NAME,
		  NULL,
		  &namebs);
      assert(status == 0);
      fprintf(stderr,"typ: %s::%s(%p,%p) = ",
	      name,
	      typ_msg_list[msg],
	      arg1,
	      arg2);
#ifdef DEBUG_INSERT
      if (msg == TYP_INSERT)
	{
	  TYP_INSERT_ARGS(ed,value);

	  fprintf(stderr,"\"%s\" ",value);
	}
#endif
#ifdef DEBUG_EXTRACT
      if (msg == TYP_EXTRACT)
	{
	  TYP_EXTRACT_ARGS(ed,bs);

	  len = strlen(bs->str);
	}
#endif
      status = mp(msg,arg1,arg2);
      fprintf(stderr,"%s",err_msg(-status));
      if (ERR_SYS(-status))
	fprintf(stderr,": %s",strerror(errno));
      fprintf(stderr,"\n");
      if (status < 0)
	return (status);
#ifdef DEBUG_OFF
      if (msg == TYP_OFF)
	{
	  TYP_OFF_ARGS(ed,off);
	  
	  fprintf(stderr,"off=%d\n",*off);
	}
#endif
#ifdef DEBUG_EXTRACT
      if (msg == TYP_EXTRACT)
	{
	  TYP_EXTRACT_ARGS(ed,bs);
	  
	  fprintf(stderr,"\"%s\"\n",bs->str + len);
	}
#endif
      return (status);

    }
  else
#endif
    return (mp(msg,arg1,arg2));
}
