/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "typ_msg.h"
#include "typ_sz.h"

/* is a t_msg_proc.
   Manages strings terminated by zero (sz means string-zero) in a possibly
   network stream. E.g tftp file names. */
t_status		typ_sz_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  t_status		status;

  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("sz");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	int		i;
	t_boolean	found_zero;

	found_zero = FALSE;
	i = 0;
	while (i < ed->b.len)
	  {
	    if (ed->b.buf[i] == 0)
	      {
		found_zero = TRUE;
		break ;
	      }
	    else
	      if ((status = str_cat_char(bs->str,
					 bs->max_len,
					 ed->b.buf[i])) < 0)
		return (status);
	    i++;
	  }
	if (!found_zero)
	  return (-ERR_BADSZ);
	return (0);
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_status	status;	
	int		len;
	int		i;

	len = strlen(str);
	if (ed->b.len < (len + 1))
	  return (-ERR_TRUNC);
	i = 0;
	while (i < len)
	  {
	    ed->b.buf[i] = str[i];
	    i++;
	  }
	ed->b.buf[i] = 0;
	return (0);
      }
    case TYP_OFF:
      {
	TYP_OFF_ARGS(ed,off);
	int		i;
	t_boolean	found_zero;

	found_zero = FALSE;
	i = 0;
	while (i < ed->b.len)
	  {
	    if (ed->b.buf[i] == 0)
	      {
		found_zero = TRUE;
		break ;
	      }
	    i++;
	  }
	(*off) = i;
	if (!found_zero)
	  return (-ERR_BADSZ);
	(*off)++;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
