/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XIPCF_H
#define XIPCF_H	1

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XmgFancy.h"
#include "a.h"
#include "lay_ether.h"
#include "lay_ip.h"
#include "typ_inaddr.h"
#include "typ_ethaddr.h"
#include "typ_8.h"
#include "typ_16.h"
#include "typ_32.h"
#include "typ_subnet.h"

#define PLUGINS_STR		"plugins" /* this string is used many times */

typedef struct			s_var
{
  char				*name;
  t_off				offset;
  size_t			size;	
  t_msg_proc			mp;
  VOID_PTR			data;
} t_var;

extern char			*tmpl_buf;
extern char			*html_buf;
extern char			*htmlize_buf;
extern t_u32			tmpl_bufsiz;
extern t_u32			html_bufsiz;
extern t_u32			htmlize_bufsiz;
extern struct in_addr		ghost_ip;
extern t_ether_addr		ghost_ether;
extern t_u16			ip_id;

typedef struct			s_xt_resources
{
  char				*xtermPath;
  char				*binEditorPath;
  char				*defaultColorName;
  char				*bodyColorName;
  char				*bodyBackgroundName;
  char				*controlsColorName;
  int				pktHelpOffset;
  Boolean			pinMode;
  Boolean			helpMode;
  Boolean			scrollMode;
  Boolean			smoothScrollMode;
  int				smoothScrollLimit;
  int				smoothScrollOffset;
} t_xt_resources;

extern XtResource		resources[];	
extern Cardinal			num_resources;
extern t_xt_resources		xt_resources;

extern t_dict			*extravars;

/* PROTO xipcf.c */
/* xipcf.c */
t_status typ_memoryzone_msg P((t_msg msg, void *arg1, void *arg2));
t_status typ_plugins_msg P((t_msg msg, void *arg1, void *arg2));
void show_xt_resources P((void));
t_status get_extra_vars_from_xrm_walk P((t_hash_elt *he, XrmDatabase db));
t_status extra_vars_walk P((t_hash_elt *he, void *unused));
t_status get_extra_vars_from_xrm P((void));
void destroy_extra_vars P((void));
t_var *var_from_vars P((char *name));
t_status var_set P((char *name, char *value));
t_status var_get P((char *name, char *str, int max_len));
t_status var_tmpl_do P((t_bridled_str *bs, char *var, void *unused));
t_status vars_init P((void));
t_status xip_cf_save P((char *fname));
int xip_cf_load_cmp P((void **p1, void **p2));
t_status xip_cf_load_walk P((t_hash_elt *he, void *unused));
t_status xip_cf_load P((char *fname));
t_status XipCfFancyFormWalk P((t_hash_elt *he, void *unused));
void XipCfFancyForm P((Widget w, Widget shell, XmgFancyFormCallbackStruct *cbs));
void XipCfFancyLink P((Widget w, Widget shell, XmgFancyLinkCallbackStruct *cbs));
void XipCfFancyTitle P((Widget w, Widget shell, XmgFancyTitleCallbackStruct *cbs));
void XipShowCfBox P((Widget parent));
#endif
