/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XIPPKT_H
#define XIPPKT_H	1

#include <X11/Intrinsic.h>
#include "XmgFancy.h"
#include "xip.h"
#include "pkt.h"

typedef struct		s_xip_pkt
{
  t_pkt			*pkt;
  Widget		shell;
  Widget		fancy;
  t_vec			*users;
  t_boolean		own_pkt;
  t_boolean		in_delete;
} t_xip_pkt;

typedef struct		s_xip_method_data
{
  t_xip_pkt		*xp;
  t_boolean		new_window;
  VOID_PTR		data;
} t_xip_method_data;

typedef t_status	(*t_xip_method_proc) P((t_xip_method_data *xmd,
						 t_vec *args));

typedef struct		s_xip_method
{
  char			*name;
  t_xip_method_proc	proc;
} t_xip_method;

typedef struct		s_xip_pktbar
{
  char			*label;
  char			*methodstr;
} t_xip_pktbar;

/* PROTO xippkt.c */
/* xippkt.c */
void setfield_prompt_ok P((Widget w, t_vec *vec, XtPointer cbs));
void setfield_prompt_pulldown_ok P((Widget w, t_vec *vec, XtPointer cbs));
void setfield_prompt_cancel P((Widget w, t_vec *vec, XtPointer cbs));
t_status xp_delete P((t_xip_pkt *xp));
t_status method_delete P((t_xip_method_data *xmd, t_vec *args));
t_status method_setfield P((t_xip_method_data *xmd, t_vec *args));
t_status method_extract P((t_xip_method_data *xmd, t_vec *args));
t_status method_trunc P((t_xip_method_data *xmd, t_vec *args));
t_status method_save P((t_xip_method_data *xmd, t_vec *args));
t_status method_load P((t_xip_method_data *xmd, t_vec *args));
t_status method_sum P((t_xip_method_data *xmd, t_vec *args));
t_status method_adaptlen P((t_xip_method_data *xmd, t_vec *args));
t_status method_cut P((t_xip_method_data *xmd, t_vec *args));
t_status method_paste P((t_xip_method_data *xmd, t_vec *args));
t_status method_edit P((t_xip_method_data *xmd, t_vec *args));
t_status method_reply P((t_xip_method_data *xmd, t_vec *args));
t_status method_add P((t_assoc *assoc));
t_status methods_init P((void));
void methods_destroy P((void));
void method_do P((t_xip_method_data *xmd, t_vec *args));
void parse_method P((t_xip_method_data *xmd, char *str));
void XipPktFancyLink P((Widget w, t_xip_pkt *xp, XmgFancyLinkCallbackStruct *cbs));
void XipPktFancyTitle P((Widget w, t_xip_pkt *xp, XmgFancyTitleCallbackStruct *cbs));
void XipPktDestroy P((Widget w, t_xip_pkt *xp, void *cbs));
t_status pktbar_add P((t_assoc *assoc));
t_status pktbar_init P((void));
void pktbar_destroy P((void));
t_status xip_pkt_html P((t_pkt *pkt, char *str, int max_len));
void XipCreatePkt P((Widget parent, t_pkt *pkt, t_boolean own_pkt));
#endif
