/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include "lay_data.h"
#include "xippktvec.h"

t_vec				*xip_pkt_vec = NULL;
extern t_boolean		verbose;
extern Widget			pktbox;

/* initializes main packet vector.
   Returns 0 if OK. Might return various errors */
t_status			xippktvec_init(VOID_DECL)
{
  t_status			status;

  if ((xip_pkt_vec = XIP_VEC_NEW(VEC_BASE,
				 &status)) == NULL)
    return (status);
  return (0);
}

/* destroys main packet vector */
VOID_FUNC			xippktvec_destroy(VOID_DECL)
{
  vec_delete(xip_pkt_vec);
}

/* duplicates a packet with xip allocation methods.
   Returns the new packet or NULL. If NULL, status is filled. */
t_pkt				*xip_pkt_dup(pkt,status)
t_pkt				*pkt;
t_status			*status;
{
  t_pkt				*npkt;

  if ((npkt = pkt_dup(pkt,
		      XIP_ALLOC_PROC,
		      XIP_FREE_PROC,
		      status)) == NULL)
    return (NULL);
  if (((*status) = vec_add(xip_pkt_vec,npkt)) < 0)
    {
      pkt_delete(npkt,XIP_FREE_PROC);
      return (NULL);
    }
  return (npkt);
}

/* registers-and-allocates a new packet to main packet vector.
   Returns packet or NULL. If NULL, status is filled */
t_pkt				*xip_pkt_new(len,mp,status)
int				len;
t_msg_proc			mp;
t_status			*status;
{
  t_pkt				*npkt;
  
  if ((npkt = pkt_new(len,
		      mp,
		      XIP_ALLOC_PROC,
		      XIP_FREE_PROC,
		      status)) == NULL)
    return (NULL);
  if (((*status) = vec_add(xip_pkt_vec,npkt)) < 0)
    {
      pkt_delete(npkt,XIP_FREE_PROC);
      return (NULL);
    }
  return (npkt);
}

/* unregisters-and-frees packet from main packet vector */
VOID_FUNC			xip_pkt_delete(pkt)
t_pkt				*pkt;
{
  VEC_RM_ELT(xip_pkt_vec,pkt);
  pkt_delete(pkt,XIP_FREE_PROC);
}

/* saves a collection of packets to a file.
   Returns 0 if OK. -ERR_OPEN if open(2) fails.
   Might return various errors. */
t_status			xip_save_collection(fname)
char				*fname;
{
  FILE				*f;
  char				basename[MAXPATHLEN];
  char				pktfname[MAXPATHLEN];
  char				*without_slash;
  t_status			status;
  char				*ptr;

  basename[0] = 0;
  if ((status = str_cat_str(basename,
			    sizeof (basename),
			    fname)) < 0)
    return (status);
  if (ptr = index(basename,'.'))
    *ptr++ = 0;
  if (without_slash = rindex(basename,'/'))
    without_slash++;
  else
    without_slash = basename; 
  if ((f = fopen(fname,"w+")) == NULL)
    return (-ERR_OPEN);
  VEC_FOR(xip_pkt_vec,t_pkt *pkt)
    {
      pktfname[0] = 0;
      if ((status = str_cat_fmt_va(pktfname,
				   sizeof (pktfname),
				   "%s_%d.pkt",
				   basename,
				   VEC_IDX)) < 0)
	goto bad;
      if ((status = pkt_save(pkt,pktfname)) < 0)
	goto bad;
      pktfname[0] = 0;
      if ((status = str_cat_fmt_va(pktfname,
				   sizeof (pktfname),
				   "%s_%d.pkt",
				   without_slash,
				   VEC_IDX)) < 0)
	goto bad;
      fprintf(f,"%s\n",pktfname);
    }
  VEC_ENDFOR;
  fclose(f);
  return (0);
bad:
  fclose(f);
  return (status);
}

/* loads a collection of packet to a file (.pkc files).
   Returns 0 if OK. -ERR_OPEN if open(2) fails. Might return various errors. */
t_status			xip_load_collection(fname)
char				*fname;
{
  FILE				*f;
  char				pktfname[MAXPATHLEN];
  t_status			status;
  char				dirname[MAXPATHLEN];
  char				tmpfname[MAXPATHLEN];
  char				*ptr;

  dirname[0] = 0;
  if ((status = str_cat_str(dirname,
			    sizeof (dirname),
			    fname)) < 0)
    return (status);
  if (ptr = rindex(dirname,'/'))
    *ptr++ = 0;
  if ((f = fopen(fname,"r")) == NULL)
    return (-ERR_OPEN);
  while (!feof(f))
    {
      t_pkt			*npkt;
      t_status			status;
      int			len;

      fgets(pktfname,sizeof (pktfname),f);
      if ((len = strlen(pktfname)) == 1)
	continue ;
      if (pktfname[len - 1] == '\n')
	pktfname[len - 1] = 0;
      tmpfname[0] = 0;
      if (index(pktfname,'/'))
	{
	  if ((status = str_cat_str(tmpfname,
				    sizeof (tmpfname),
				    pktfname)) < 0)
	    return (status);
	}
      else
	{
	  if ((status = str_cat_fmt_va(tmpfname,
				       sizeof (tmpfname),
				       "%s/%s",
				       dirname,
				       pktfname)) < 0)
	    return (status);
	}
      if ((npkt = xip_pkt_new(1,
			      lay_data_msg,
			      &status)) == NULL)
	goto bad;
      if ((status = pkt_load(npkt,
			     tmpfname,
			     XIP_ALLOC_PROC,
			     XIP_FREE_PROC)) < 0)
	{
	  err_print(-status,"pkt_load %s",tmpfname);
	  xip_pkt_delete(npkt);
	  continue ;
	}
      XipCreatePkt(pktbox,npkt,TRUE);
    }
  fclose(f);
  return (0);
bad:
  fclose(f);
  return (status);
}
